# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudforceOneRequestResult',
    'AwaitableGetCloudforceOneRequestResult',
    'get_cloudforce_one_request',
    'get_cloudforce_one_request_output',
]

@pulumi.output_type
class GetCloudforceOneRequestResult:
    """
    A collection of values returned by getCloudforceOneRequest.
    """
    def __init__(__self__, account_id=None, completed=None, content=None, created=None, filter=None, id=None, message_tokens=None, priority=None, readable_id=None, request=None, request_id=None, status=None, summary=None, tlp=None, tokens=None, updated=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if completed and not isinstance(completed, str):
            raise TypeError("Expected argument 'completed' to be a str")
        pulumi.set(__self__, "completed", completed)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message_tokens and not isinstance(message_tokens, int):
            raise TypeError("Expected argument 'message_tokens' to be a int")
        pulumi.set(__self__, "message_tokens", message_tokens)
        if priority and not isinstance(priority, str):
            raise TypeError("Expected argument 'priority' to be a str")
        pulumi.set(__self__, "priority", priority)
        if readable_id and not isinstance(readable_id, str):
            raise TypeError("Expected argument 'readable_id' to be a str")
        pulumi.set(__self__, "readable_id", readable_id)
        if request and not isinstance(request, str):
            raise TypeError("Expected argument 'request' to be a str")
        pulumi.set(__self__, "request", request)
        if request_id and not isinstance(request_id, str):
            raise TypeError("Expected argument 'request_id' to be a str")
        pulumi.set(__self__, "request_id", request_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if summary and not isinstance(summary, str):
            raise TypeError("Expected argument 'summary' to be a str")
        pulumi.set(__self__, "summary", summary)
        if tlp and not isinstance(tlp, str):
            raise TypeError("Expected argument 'tlp' to be a str")
        pulumi.set(__self__, "tlp", tlp)
        if tokens and not isinstance(tokens, int):
            raise TypeError("Expected argument 'tokens' to be a int")
        pulumi.set(__self__, "tokens", tokens)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def completed(self) -> builtins.str:
        return pulumi.get(self, "completed")

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetCloudforceOneRequestFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="messageTokens")
    def message_tokens(self) -> builtins.int:
        """
        Tokens for the request messages.
        """
        return pulumi.get(self, "message_tokens")

    @property
    @pulumi.getter
    def priority(self) -> builtins.str:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="readableId")
    def readable_id(self) -> builtins.str:
        """
        Readable Request ID.
        """
        return pulumi.get(self, "readable_id")

    @property
    @pulumi.getter
    def request(self) -> builtins.str:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def summary(self) -> builtins.str:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def tlp(self) -> builtins.str:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @property
    @pulumi.getter
    def tokens(self) -> builtins.int:
        """
        Tokens for the request.
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter
    def updated(self) -> builtins.str:
        return pulumi.get(self, "updated")


class AwaitableGetCloudforceOneRequestResult(GetCloudforceOneRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudforceOneRequestResult(
            account_id=self.account_id,
            completed=self.completed,
            content=self.content,
            created=self.created,
            filter=self.filter,
            id=self.id,
            message_tokens=self.message_tokens,
            priority=self.priority,
            readable_id=self.readable_id,
            request=self.request,
            request_id=self.request_id,
            status=self.status,
            summary=self.summary,
            tlp=self.tlp,
            tokens=self.tokens,
            updated=self.updated)


def get_cloudforce_one_request(account_id: Optional[builtins.str] = None,
                               filter: Optional[Union['GetCloudforceOneRequestFilterArgs', 'GetCloudforceOneRequestFilterArgsDict']] = None,
                               request_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudforceOneRequestResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_request = cloudflare.get_cloudforce_one_request(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str request_id: UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['requestId'] = request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCloudforceOneRequest:getCloudforceOneRequest', __args__, opts=opts, typ=GetCloudforceOneRequestResult).value

    return AwaitableGetCloudforceOneRequestResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        completed=pulumi.get(__ret__, 'completed'),
        content=pulumi.get(__ret__, 'content'),
        created=pulumi.get(__ret__, 'created'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        message_tokens=pulumi.get(__ret__, 'message_tokens'),
        priority=pulumi.get(__ret__, 'priority'),
        readable_id=pulumi.get(__ret__, 'readable_id'),
        request=pulumi.get(__ret__, 'request'),
        request_id=pulumi.get(__ret__, 'request_id'),
        status=pulumi.get(__ret__, 'status'),
        summary=pulumi.get(__ret__, 'summary'),
        tlp=pulumi.get(__ret__, 'tlp'),
        tokens=pulumi.get(__ret__, 'tokens'),
        updated=pulumi.get(__ret__, 'updated'))
def get_cloudforce_one_request_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                      filter: Optional[pulumi.Input[Optional[Union['GetCloudforceOneRequestFilterArgs', 'GetCloudforceOneRequestFilterArgsDict']]]] = None,
                                      request_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudforceOneRequestResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_request = cloudflare.get_cloudforce_one_request(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str request_id: UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['requestId'] = request_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCloudforceOneRequest:getCloudforceOneRequest', __args__, opts=opts, typ=GetCloudforceOneRequestResult)
    return __ret__.apply(lambda __response__: GetCloudforceOneRequestResult(
        account_id=pulumi.get(__response__, 'account_id'),
        completed=pulumi.get(__response__, 'completed'),
        content=pulumi.get(__response__, 'content'),
        created=pulumi.get(__response__, 'created'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        message_tokens=pulumi.get(__response__, 'message_tokens'),
        priority=pulumi.get(__response__, 'priority'),
        readable_id=pulumi.get(__response__, 'readable_id'),
        request=pulumi.get(__response__, 'request'),
        request_id=pulumi.get(__response__, 'request_id'),
        status=pulumi.get(__response__, 'status'),
        summary=pulumi.get(__response__, 'summary'),
        tlp=pulumi.get(__response__, 'tlp'),
        tokens=pulumi.get(__response__, 'tokens'),
        updated=pulumi.get(__response__, 'updated')))
