# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCloudforceOneRequestPriorityResult',
    'AwaitableGetCloudforceOneRequestPriorityResult',
    'get_cloudforce_one_request_priority',
    'get_cloudforce_one_request_priority_output',
]

@pulumi.output_type
class GetCloudforceOneRequestPriorityResult:
    """
    A collection of values returned by getCloudforceOneRequestPriority.
    """
    def __init__(__self__, account_id=None, completed=None, content=None, created=None, id=None, message_tokens=None, priority=None, priority_id=None, readable_id=None, request=None, status=None, summary=None, tlp=None, tokens=None, updated=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if completed and not isinstance(completed, str):
            raise TypeError("Expected argument 'completed' to be a str")
        pulumi.set(__self__, "completed", completed)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message_tokens and not isinstance(message_tokens, int):
            raise TypeError("Expected argument 'message_tokens' to be a int")
        pulumi.set(__self__, "message_tokens", message_tokens)
        if priority and not isinstance(priority, str):
            raise TypeError("Expected argument 'priority' to be a str")
        pulumi.set(__self__, "priority", priority)
        if priority_id and not isinstance(priority_id, str):
            raise TypeError("Expected argument 'priority_id' to be a str")
        pulumi.set(__self__, "priority_id", priority_id)
        if readable_id and not isinstance(readable_id, str):
            raise TypeError("Expected argument 'readable_id' to be a str")
        pulumi.set(__self__, "readable_id", readable_id)
        if request and not isinstance(request, str):
            raise TypeError("Expected argument 'request' to be a str")
        pulumi.set(__self__, "request", request)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if summary and not isinstance(summary, str):
            raise TypeError("Expected argument 'summary' to be a str")
        pulumi.set(__self__, "summary", summary)
        if tlp and not isinstance(tlp, str):
            raise TypeError("Expected argument 'tlp' to be a str")
        pulumi.set(__self__, "tlp", tlp)
        if tokens and not isinstance(tokens, int):
            raise TypeError("Expected argument 'tokens' to be a int")
        pulumi.set(__self__, "tokens", tokens)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def completed(self) -> builtins.str:
        return pulumi.get(self, "completed")

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="messageTokens")
    def message_tokens(self) -> builtins.int:
        """
        Tokens for the request messages.
        """
        return pulumi.get(self, "message_tokens")

    @property
    @pulumi.getter
    def priority(self) -> builtins.str:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="priorityId")
    def priority_id(self) -> builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "priority_id")

    @property
    @pulumi.getter(name="readableId")
    def readable_id(self) -> builtins.str:
        """
        Readable Request ID.
        """
        return pulumi.get(self, "readable_id")

    @property
    @pulumi.getter
    def request(self) -> builtins.str:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def summary(self) -> builtins.str:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def tlp(self) -> builtins.str:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @property
    @pulumi.getter
    def tokens(self) -> builtins.int:
        """
        Tokens for the request.
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter
    def updated(self) -> builtins.str:
        return pulumi.get(self, "updated")


class AwaitableGetCloudforceOneRequestPriorityResult(GetCloudforceOneRequestPriorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudforceOneRequestPriorityResult(
            account_id=self.account_id,
            completed=self.completed,
            content=self.content,
            created=self.created,
            id=self.id,
            message_tokens=self.message_tokens,
            priority=self.priority,
            priority_id=self.priority_id,
            readable_id=self.readable_id,
            request=self.request,
            status=self.status,
            summary=self.summary,
            tlp=self.tlp,
            tokens=self.tokens,
            updated=self.updated)


def get_cloudforce_one_request_priority(account_id: Optional[builtins.str] = None,
                                        priority_id: Optional[builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudforceOneRequestPriorityResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_request_priority = cloudflare.get_cloudforce_one_request_priority(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        priority_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str priority_id: UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['priorityId'] = priority_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCloudforceOneRequestPriority:getCloudforceOneRequestPriority', __args__, opts=opts, typ=GetCloudforceOneRequestPriorityResult).value

    return AwaitableGetCloudforceOneRequestPriorityResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        completed=pulumi.get(__ret__, 'completed'),
        content=pulumi.get(__ret__, 'content'),
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'),
        message_tokens=pulumi.get(__ret__, 'message_tokens'),
        priority=pulumi.get(__ret__, 'priority'),
        priority_id=pulumi.get(__ret__, 'priority_id'),
        readable_id=pulumi.get(__ret__, 'readable_id'),
        request=pulumi.get(__ret__, 'request'),
        status=pulumi.get(__ret__, 'status'),
        summary=pulumi.get(__ret__, 'summary'),
        tlp=pulumi.get(__ret__, 'tlp'),
        tokens=pulumi.get(__ret__, 'tokens'),
        updated=pulumi.get(__ret__, 'updated'))
def get_cloudforce_one_request_priority_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                               priority_id: Optional[pulumi.Input[builtins.str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudforceOneRequestPriorityResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_request_priority = cloudflare.get_cloudforce_one_request_priority(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        priority_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str priority_id: UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['priorityId'] = priority_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCloudforceOneRequestPriority:getCloudforceOneRequestPriority', __args__, opts=opts, typ=GetCloudforceOneRequestPriorityResult)
    return __ret__.apply(lambda __response__: GetCloudforceOneRequestPriorityResult(
        account_id=pulumi.get(__response__, 'account_id'),
        completed=pulumi.get(__response__, 'completed'),
        content=pulumi.get(__response__, 'content'),
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id'),
        message_tokens=pulumi.get(__response__, 'message_tokens'),
        priority=pulumi.get(__response__, 'priority'),
        priority_id=pulumi.get(__response__, 'priority_id'),
        readable_id=pulumi.get(__response__, 'readable_id'),
        request=pulumi.get(__response__, 'request'),
        status=pulumi.get(__response__, 'status'),
        summary=pulumi.get(__response__, 'summary'),
        tlp=pulumi.get(__response__, 'tlp'),
        tokens=pulumi.get(__response__, 'tokens'),
        updated=pulumi.get(__response__, 'updated')))
