# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCloudforceOneRequestsResult',
    'AwaitableGetCloudforceOneRequestsResult',
    'get_cloudforce_one_requests',
    'get_cloudforce_one_requests_output',
]

@pulumi.output_type
class GetCloudforceOneRequestsResult:
    """
    A collection of values returned by getCloudforceOneRequests.
    """
    def __init__(__self__, account_id=None, completed_after=None, completed_before=None, created_after=None, created_before=None, id=None, max_items=None, page=None, per_page=None, request_type=None, results=None, sort_by=None, sort_order=None, status=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if completed_after and not isinstance(completed_after, str):
            raise TypeError("Expected argument 'completed_after' to be a str")
        pulumi.set(__self__, "completed_after", completed_after)
        if completed_before and not isinstance(completed_before, str):
            raise TypeError("Expected argument 'completed_before' to be a str")
        pulumi.set(__self__, "completed_before", completed_before)
        if created_after and not isinstance(created_after, str):
            raise TypeError("Expected argument 'created_after' to be a str")
        pulumi.set(__self__, "created_after", created_after)
        if created_before and not isinstance(created_before, str):
            raise TypeError("Expected argument 'created_before' to be a str")
        pulumi.set(__self__, "created_before", created_before)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if per_page and not isinstance(per_page, int):
            raise TypeError("Expected argument 'per_page' to be a int")
        pulumi.set(__self__, "per_page", per_page)
        if request_type and not isinstance(request_type, str):
            raise TypeError("Expected argument 'request_type' to be a str")
        pulumi.set(__self__, "request_type", request_type)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if sort_by and not isinstance(sort_by, str):
            raise TypeError("Expected argument 'sort_by' to be a str")
        pulumi.set(__self__, "sort_by", sort_by)
        if sort_order and not isinstance(sort_order, str):
            raise TypeError("Expected argument 'sort_order' to be a str")
        pulumi.set(__self__, "sort_order", sort_order)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="completedAfter")
    def completed_after(self) -> Optional[builtins.str]:
        """
        Retrieve requests completed after this time.
        """
        return pulumi.get(self, "completed_after")

    @property
    @pulumi.getter(name="completedBefore")
    def completed_before(self) -> Optional[builtins.str]:
        """
        Retrieve requests completed before this time.
        """
        return pulumi.get(self, "completed_before")

    @property
    @pulumi.getter(name="createdAfter")
    def created_after(self) -> Optional[builtins.str]:
        """
        Retrieve requests created after this time.
        """
        return pulumi.get(self, "created_after")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[builtins.str]:
        """
        Retrieve requests created before this time.
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def page(self) -> builtins.int:
        """
        Page number of results.
        """
        return pulumi.get(self, "page")

    @property
    @pulumi.getter(name="perPage")
    def per_page(self) -> builtins.int:
        """
        Number of results per page.
        """
        return pulumi.get(self, "per_page")

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[builtins.str]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request_type")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetCloudforceOneRequestsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[builtins.str]:
        """
        Field to sort results by.
        """
        return pulumi.get(self, "sort_by")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> Optional[builtins.str]:
        """
        Sort order (asc or desc).
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")


class AwaitableGetCloudforceOneRequestsResult(GetCloudforceOneRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudforceOneRequestsResult(
            account_id=self.account_id,
            completed_after=self.completed_after,
            completed_before=self.completed_before,
            created_after=self.created_after,
            created_before=self.created_before,
            id=self.id,
            max_items=self.max_items,
            page=self.page,
            per_page=self.per_page,
            request_type=self.request_type,
            results=self.results,
            sort_by=self.sort_by,
            sort_order=self.sort_order,
            status=self.status)


def get_cloudforce_one_requests(account_id: Optional[builtins.str] = None,
                                completed_after: Optional[builtins.str] = None,
                                completed_before: Optional[builtins.str] = None,
                                created_after: Optional[builtins.str] = None,
                                created_before: Optional[builtins.str] = None,
                                max_items: Optional[builtins.int] = None,
                                page: Optional[builtins.int] = None,
                                per_page: Optional[builtins.int] = None,
                                request_type: Optional[builtins.str] = None,
                                sort_by: Optional[builtins.str] = None,
                                sort_order: Optional[builtins.str] = None,
                                status: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudforceOneRequestsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_requests = cloudflare.get_cloudforce_one_requests(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        page=0,
        per_page=10,
        completed_after="2022-01-01T00:00:00Z",
        completed_before="2024-01-01T00:00:00Z",
        created_after="2022-01-01T00:00:00Z",
        created_before="2024-01-01T00:00:00Z",
        request_type="Victomology",
        sort_by="created",
        sort_order="asc",
        status="open")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str completed_after: Retrieve requests completed after this time.
    :param builtins.str completed_before: Retrieve requests completed before this time.
    :param builtins.str created_after: Retrieve requests created after this time.
    :param builtins.str created_before: Retrieve requests created before this time.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.int page: Page number of results.
    :param builtins.int per_page: Number of results per page.
    :param builtins.str request_type: Requested information from request.
    :param builtins.str sort_by: Field to sort results by.
    :param builtins.str sort_order: Sort order (asc or desc).
           Available values: "asc", "desc".
    :param builtins.str status: Request Status.
           Available values: "open", "accepted", "reported", "approved", "completed", "declined".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['completedAfter'] = completed_after
    __args__['completedBefore'] = completed_before
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['maxItems'] = max_items
    __args__['page'] = page
    __args__['perPage'] = per_page
    __args__['requestType'] = request_type
    __args__['sortBy'] = sort_by
    __args__['sortOrder'] = sort_order
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCloudforceOneRequests:getCloudforceOneRequests', __args__, opts=opts, typ=GetCloudforceOneRequestsResult).value

    return AwaitableGetCloudforceOneRequestsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        completed_after=pulumi.get(__ret__, 'completed_after'),
        completed_before=pulumi.get(__ret__, 'completed_before'),
        created_after=pulumi.get(__ret__, 'created_after'),
        created_before=pulumi.get(__ret__, 'created_before'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        page=pulumi.get(__ret__, 'page'),
        per_page=pulumi.get(__ret__, 'per_page'),
        request_type=pulumi.get(__ret__, 'request_type'),
        results=pulumi.get(__ret__, 'results'),
        sort_by=pulumi.get(__ret__, 'sort_by'),
        sort_order=pulumi.get(__ret__, 'sort_order'),
        status=pulumi.get(__ret__, 'status'))
def get_cloudforce_one_requests_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                       completed_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       completed_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       created_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       created_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                       page: Optional[pulumi.Input[builtins.int]] = None,
                                       per_page: Optional[pulumi.Input[builtins.int]] = None,
                                       request_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       sort_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       sort_order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudforceOneRequestsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_cloudforce_one_requests = cloudflare.get_cloudforce_one_requests(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        page=0,
        per_page=10,
        completed_after="2022-01-01T00:00:00Z",
        completed_before="2024-01-01T00:00:00Z",
        created_after="2022-01-01T00:00:00Z",
        created_before="2024-01-01T00:00:00Z",
        request_type="Victomology",
        sort_by="created",
        sort_order="asc",
        status="open")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str completed_after: Retrieve requests completed after this time.
    :param builtins.str completed_before: Retrieve requests completed before this time.
    :param builtins.str created_after: Retrieve requests created after this time.
    :param builtins.str created_before: Retrieve requests created before this time.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.int page: Page number of results.
    :param builtins.int per_page: Number of results per page.
    :param builtins.str request_type: Requested information from request.
    :param builtins.str sort_by: Field to sort results by.
    :param builtins.str sort_order: Sort order (asc or desc).
           Available values: "asc", "desc".
    :param builtins.str status: Request Status.
           Available values: "open", "accepted", "reported", "approved", "completed", "declined".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['completedAfter'] = completed_after
    __args__['completedBefore'] = completed_before
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['maxItems'] = max_items
    __args__['page'] = page
    __args__['perPage'] = per_page
    __args__['requestType'] = request_type
    __args__['sortBy'] = sort_by
    __args__['sortOrder'] = sort_order
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCloudforceOneRequests:getCloudforceOneRequests', __args__, opts=opts, typ=GetCloudforceOneRequestsResult)
    return __ret__.apply(lambda __response__: GetCloudforceOneRequestsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        completed_after=pulumi.get(__response__, 'completed_after'),
        completed_before=pulumi.get(__response__, 'completed_before'),
        created_after=pulumi.get(__response__, 'created_after'),
        created_before=pulumi.get(__response__, 'created_before'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        page=pulumi.get(__response__, 'page'),
        per_page=pulumi.get(__response__, 'per_page'),
        request_type=pulumi.get(__response__, 'request_type'),
        results=pulumi.get(__response__, 'results'),
        sort_by=pulumi.get(__response__, 'sort_by'),
        sort_order=pulumi.get(__response__, 'sort_order'),
        status=pulumi.get(__response__, 'status')))
