# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCustomPagesResult',
    'AwaitableGetCustomPagesResult',
    'get_custom_pages',
    'get_custom_pages_output',
]

@pulumi.output_type
class GetCustomPagesResult:
    """
    A collection of values returned by getCustomPages.
    """
    def __init__(__self__, account_id=None, id=None, identifier=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCustomPagesResult(GetCustomPagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomPagesResult(
            account_id=self.account_id,
            id=self.id,
            identifier=self.identifier,
            zone_id=self.zone_id)


def get_custom_pages(account_id: Optional[builtins.str] = None,
                     identifier: Optional[builtins.str] = None,
                     zone_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomPagesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_pages = cloudflare.get_custom_pages(identifier="023e105f4ecef8ad9ca31a8372d0c353",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str identifier: Identifier
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCustomPages:getCustomPages', __args__, opts=opts, typ=GetCustomPagesResult).value

    return AwaitableGetCustomPagesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_custom_pages_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            identifier: Optional[pulumi.Input[builtins.str]] = None,
                            zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomPagesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_pages = cloudflare.get_custom_pages(identifier="023e105f4ecef8ad9ca31a8372d0c353",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str identifier: Identifier
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['identifier'] = identifier
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCustomPages:getCustomPages', __args__, opts=opts, typ=GetCustomPagesResult)
    return __ret__.apply(lambda __response__: GetCustomPagesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        zone_id=pulumi.get(__response__, 'zone_id')))
