# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCustomSslResult',
    'AwaitableGetCustomSslResult',
    'get_custom_ssl',
    'get_custom_ssl_output',
]

@pulumi.output_type
class GetCustomSslResult:
    """
    A collection of values returned by getCustomSsl.
    """
    def __init__(__self__, bundle_method=None, custom_certificate_id=None, expires_on=None, filter=None, geo_restrictions=None, hosts=None, id=None, issuer=None, keyless_server=None, modified_on=None, policy=None, priority=None, signature=None, status=None, uploaded_on=None, zone_id=None):
        if bundle_method and not isinstance(bundle_method, str):
            raise TypeError("Expected argument 'bundle_method' to be a str")
        pulumi.set(__self__, "bundle_method", bundle_method)
        if custom_certificate_id and not isinstance(custom_certificate_id, str):
            raise TypeError("Expected argument 'custom_certificate_id' to be a str")
        pulumi.set(__self__, "custom_certificate_id", custom_certificate_id)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if geo_restrictions and not isinstance(geo_restrictions, dict):
            raise TypeError("Expected argument 'geo_restrictions' to be a dict")
        pulumi.set(__self__, "geo_restrictions", geo_restrictions)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if keyless_server and not isinstance(keyless_server, dict):
            raise TypeError("Expected argument 'keyless_server' to be a dict")
        pulumi.set(__self__, "keyless_server", keyless_server)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if priority and not isinstance(priority, float):
            raise TypeError("Expected argument 'priority' to be a float")
        pulumi.set(__self__, "priority", priority)
        if signature and not isinstance(signature, str):
            raise TypeError("Expected argument 'signature' to be a str")
        pulumi.set(__self__, "signature", signature)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if uploaded_on and not isinstance(uploaded_on, str):
            raise TypeError("Expected argument 'uploaded_on' to be a str")
        pulumi.set(__self__, "uploaded_on", uploaded_on)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="bundleMethod")
    def bundle_method(self) -> builtins.str:
        """
        A ubiquitous bundle has the highest probability of being verified everywhere, even by clients using outdated or unusual trust stores. An optimal bundle uses the shortest chain and newest intermediates. And the force bundle verifies the chain, but does not otherwise modify it.
        Available values: "ubiquitous", "optimal", "force".
        """
        return pulumi.get(self, "bundle_method")

    @property
    @pulumi.getter(name="customCertificateId")
    def custom_certificate_id(self) -> Optional[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "custom_certificate_id")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> builtins.str:
        """
        When the certificate from the authority expires.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetCustomSslFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="geoRestrictions")
    def geo_restrictions(self) -> 'outputs.GetCustomSslGeoRestrictionsResult':
        """
        Specify the region where your private key can be held locally for optimal TLS performance. HTTPS connections to any excluded data center will still be fully encrypted, but will incur some latency while Keyless SSL is used to complete the handshake with the nearest allowed data center. Options allow distribution to only to U.S. data centers, only to E.U. data centers, or only to highest security data centers. Default distribution is to all Cloudflare datacenters, for optimal performance.
        """
        return pulumi.get(self, "geo_restrictions")

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="keylessServer")
    def keyless_server(self) -> 'outputs.GetCustomSslKeylessServerResult':
        return pulumi.get(self, "keyless_server")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        When the certificate was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def policy(self) -> builtins.str:
        """
        Specify the policy that determines the region where your private key will be held locally. HTTPS connections to any excluded data center will still be fully encrypted, but will incur some latency while Keyless SSL is used to complete the handshake with the nearest allowed data center. Any combination of countries, specified by their two letter country code (https://en.wikipedia.org/wiki/ISO*3166-1*alpha-2#Officially*assigned*code_elements) can be chosen, such as 'country: IN', as well as 'region: EU' which refers to the EU region. If there are too few data centers satisfying the policy, it will be rejected.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def priority(self) -> builtins.float:
        """
        The order/priority in which the certificate will be used in a request. The higher priority will break ties across overlapping 'legacy*custom' certificates, but 'legacy*custom' certificates will always supercede 'sni_custom' certificates.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def signature(self) -> builtins.str:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the zone's custom SSL.
        Available values: "active", "expired", "deleted", "pending", "initializing".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> builtins.str:
        """
        When the certificate was uploaded to Cloudflare.
        """
        return pulumi.get(self, "uploaded_on")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCustomSslResult(GetCustomSslResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomSslResult(
            bundle_method=self.bundle_method,
            custom_certificate_id=self.custom_certificate_id,
            expires_on=self.expires_on,
            filter=self.filter,
            geo_restrictions=self.geo_restrictions,
            hosts=self.hosts,
            id=self.id,
            issuer=self.issuer,
            keyless_server=self.keyless_server,
            modified_on=self.modified_on,
            policy=self.policy,
            priority=self.priority,
            signature=self.signature,
            status=self.status,
            uploaded_on=self.uploaded_on,
            zone_id=self.zone_id)


def get_custom_ssl(custom_certificate_id: Optional[builtins.str] = None,
                   filter: Optional[Union['GetCustomSslFilterArgs', 'GetCustomSslFilterArgsDict']] = None,
                   zone_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomSslResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_ssl = cloudflare.get_custom_ssl(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        custom_certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str custom_certificate_id: Identifier.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['customCertificateId'] = custom_certificate_id
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCustomSsl:getCustomSsl', __args__, opts=opts, typ=GetCustomSslResult).value

    return AwaitableGetCustomSslResult(
        bundle_method=pulumi.get(__ret__, 'bundle_method'),
        custom_certificate_id=pulumi.get(__ret__, 'custom_certificate_id'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        filter=pulumi.get(__ret__, 'filter'),
        geo_restrictions=pulumi.get(__ret__, 'geo_restrictions'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        issuer=pulumi.get(__ret__, 'issuer'),
        keyless_server=pulumi.get(__ret__, 'keyless_server'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        policy=pulumi.get(__ret__, 'policy'),
        priority=pulumi.get(__ret__, 'priority'),
        signature=pulumi.get(__ret__, 'signature'),
        status=pulumi.get(__ret__, 'status'),
        uploaded_on=pulumi.get(__ret__, 'uploaded_on'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_custom_ssl_output(custom_certificate_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          filter: Optional[pulumi.Input[Optional[Union['GetCustomSslFilterArgs', 'GetCustomSslFilterArgsDict']]]] = None,
                          zone_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomSslResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_ssl = cloudflare.get_custom_ssl(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        custom_certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str custom_certificate_id: Identifier.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['customCertificateId'] = custom_certificate_id
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCustomSsl:getCustomSsl', __args__, opts=opts, typ=GetCustomSslResult)
    return __ret__.apply(lambda __response__: GetCustomSslResult(
        bundle_method=pulumi.get(__response__, 'bundle_method'),
        custom_certificate_id=pulumi.get(__response__, 'custom_certificate_id'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        filter=pulumi.get(__response__, 'filter'),
        geo_restrictions=pulumi.get(__response__, 'geo_restrictions'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        issuer=pulumi.get(__response__, 'issuer'),
        keyless_server=pulumi.get(__response__, 'keyless_server'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        policy=pulumi.get(__response__, 'policy'),
        priority=pulumi.get(__response__, 'priority'),
        signature=pulumi.get(__response__, 'signature'),
        status=pulumi.get(__response__, 'status'),
        uploaded_on=pulumi.get(__response__, 'uploaded_on'),
        zone_id=pulumi.get(__response__, 'zone_id')))
