# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDnsFirewallResult',
    'AwaitableGetDnsFirewallResult',
    'get_dns_firewall',
    'get_dns_firewall_output',
]

@pulumi.output_type
class GetDnsFirewallResult:
    """
    A collection of values returned by getDnsFirewall.
    """
    def __init__(__self__, account_id=None, attack_mitigation=None, deprecate_any_requests=None, dns_firewall_id=None, dns_firewall_ips=None, ecs_fallback=None, id=None, maximum_cache_ttl=None, minimum_cache_ttl=None, modified_on=None, name=None, negative_cache_ttl=None, ratelimit=None, retries=None, upstream_ips=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if attack_mitigation and not isinstance(attack_mitigation, dict):
            raise TypeError("Expected argument 'attack_mitigation' to be a dict")
        pulumi.set(__self__, "attack_mitigation", attack_mitigation)
        if deprecate_any_requests and not isinstance(deprecate_any_requests, bool):
            raise TypeError("Expected argument 'deprecate_any_requests' to be a bool")
        pulumi.set(__self__, "deprecate_any_requests", deprecate_any_requests)
        if dns_firewall_id and not isinstance(dns_firewall_id, str):
            raise TypeError("Expected argument 'dns_firewall_id' to be a str")
        pulumi.set(__self__, "dns_firewall_id", dns_firewall_id)
        if dns_firewall_ips and not isinstance(dns_firewall_ips, list):
            raise TypeError("Expected argument 'dns_firewall_ips' to be a list")
        pulumi.set(__self__, "dns_firewall_ips", dns_firewall_ips)
        if ecs_fallback and not isinstance(ecs_fallback, bool):
            raise TypeError("Expected argument 'ecs_fallback' to be a bool")
        pulumi.set(__self__, "ecs_fallback", ecs_fallback)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maximum_cache_ttl and not isinstance(maximum_cache_ttl, float):
            raise TypeError("Expected argument 'maximum_cache_ttl' to be a float")
        pulumi.set(__self__, "maximum_cache_ttl", maximum_cache_ttl)
        if minimum_cache_ttl and not isinstance(minimum_cache_ttl, float):
            raise TypeError("Expected argument 'minimum_cache_ttl' to be a float")
        pulumi.set(__self__, "minimum_cache_ttl", minimum_cache_ttl)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if negative_cache_ttl and not isinstance(negative_cache_ttl, float):
            raise TypeError("Expected argument 'negative_cache_ttl' to be a float")
        pulumi.set(__self__, "negative_cache_ttl", negative_cache_ttl)
        if ratelimit and not isinstance(ratelimit, float):
            raise TypeError("Expected argument 'ratelimit' to be a float")
        pulumi.set(__self__, "ratelimit", ratelimit)
        if retries and not isinstance(retries, float):
            raise TypeError("Expected argument 'retries' to be a float")
        pulumi.set(__self__, "retries", retries)
        if upstream_ips and not isinstance(upstream_ips, list):
            raise TypeError("Expected argument 'upstream_ips' to be a list")
        pulumi.set(__self__, "upstream_ips", upstream_ips)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="attackMitigation")
    def attack_mitigation(self) -> 'outputs.GetDnsFirewallAttackMitigationResult':
        """
        Attack mitigation settings
        """
        return pulumi.get(self, "attack_mitigation")

    @property
    @pulumi.getter(name="deprecateAnyRequests")
    def deprecate_any_requests(self) -> builtins.bool:
        """
        Whether to refuse to answer queries for the ANY type
        """
        return pulumi.get(self, "deprecate_any_requests")

    @property
    @pulumi.getter(name="dnsFirewallId")
    def dns_firewall_id(self) -> Optional[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "dns_firewall_id")

    @property
    @pulumi.getter(name="dnsFirewallIps")
    def dns_firewall_ips(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "dns_firewall_ips")

    @property
    @pulumi.getter(name="ecsFallback")
    def ecs_fallback(self) -> builtins.bool:
        """
        Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        """
        return pulumi.get(self, "ecs_fallback")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maximumCacheTtl")
    def maximum_cache_ttl(self) -> builtins.float:
        """
        Maximum DNS cache TTL This setting sets an upper bound on DNS TTLs for purposes of caching between DNS Firewall and the upstream servers. Higher TTLs will be decreased to the maximum defined here for caching purposes.
        """
        return pulumi.get(self, "maximum_cache_ttl")

    @property
    @pulumi.getter(name="minimumCacheTtl")
    def minimum_cache_ttl(self) -> builtins.float:
        """
        Minimum DNS cache TTL This setting sets a lower bound on DNS TTLs for purposes of caching between DNS Firewall and the upstream servers. Lower TTLs will be increased to the minimum defined here for caching purposes.
        """
        return pulumi.get(self, "minimum_cache_ttl")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        Last modification of DNS Firewall cluster
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        DNS Firewall cluster name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="negativeCacheTtl")
    def negative_cache_ttl(self) -> builtins.float:
        """
        Negative DNS cache TTL This setting controls how long DNS Firewall should cache negative responses (e.g., NXDOMAIN) from the upstream servers.
        """
        return pulumi.get(self, "negative_cache_ttl")

    @property
    @pulumi.getter
    def ratelimit(self) -> builtins.float:
        """
        Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        """
        return pulumi.get(self, "ratelimit")

    @property
    @pulumi.getter
    def retries(self) -> builtins.float:
        """
        Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="upstreamIps")
    def upstream_ips(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "upstream_ips")


class AwaitableGetDnsFirewallResult(GetDnsFirewallResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsFirewallResult(
            account_id=self.account_id,
            attack_mitigation=self.attack_mitigation,
            deprecate_any_requests=self.deprecate_any_requests,
            dns_firewall_id=self.dns_firewall_id,
            dns_firewall_ips=self.dns_firewall_ips,
            ecs_fallback=self.ecs_fallback,
            id=self.id,
            maximum_cache_ttl=self.maximum_cache_ttl,
            minimum_cache_ttl=self.minimum_cache_ttl,
            modified_on=self.modified_on,
            name=self.name,
            negative_cache_ttl=self.negative_cache_ttl,
            ratelimit=self.ratelimit,
            retries=self.retries,
            upstream_ips=self.upstream_ips)


def get_dns_firewall(account_id: Optional[builtins.str] = None,
                     dns_firewall_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsFirewallResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_dns_firewall = cloudflare.get_dns_firewall(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        dns_firewall_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str dns_firewall_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['dnsFirewallId'] = dns_firewall_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getDnsFirewall:getDnsFirewall', __args__, opts=opts, typ=GetDnsFirewallResult).value

    return AwaitableGetDnsFirewallResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        attack_mitigation=pulumi.get(__ret__, 'attack_mitigation'),
        deprecate_any_requests=pulumi.get(__ret__, 'deprecate_any_requests'),
        dns_firewall_id=pulumi.get(__ret__, 'dns_firewall_id'),
        dns_firewall_ips=pulumi.get(__ret__, 'dns_firewall_ips'),
        ecs_fallback=pulumi.get(__ret__, 'ecs_fallback'),
        id=pulumi.get(__ret__, 'id'),
        maximum_cache_ttl=pulumi.get(__ret__, 'maximum_cache_ttl'),
        minimum_cache_ttl=pulumi.get(__ret__, 'minimum_cache_ttl'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        negative_cache_ttl=pulumi.get(__ret__, 'negative_cache_ttl'),
        ratelimit=pulumi.get(__ret__, 'ratelimit'),
        retries=pulumi.get(__ret__, 'retries'),
        upstream_ips=pulumi.get(__ret__, 'upstream_ips'))
def get_dns_firewall_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                            dns_firewall_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsFirewallResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_dns_firewall = cloudflare.get_dns_firewall(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        dns_firewall_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str dns_firewall_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['dnsFirewallId'] = dns_firewall_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getDnsFirewall:getDnsFirewall', __args__, opts=opts, typ=GetDnsFirewallResult)
    return __ret__.apply(lambda __response__: GetDnsFirewallResult(
        account_id=pulumi.get(__response__, 'account_id'),
        attack_mitigation=pulumi.get(__response__, 'attack_mitigation'),
        deprecate_any_requests=pulumi.get(__response__, 'deprecate_any_requests'),
        dns_firewall_id=pulumi.get(__response__, 'dns_firewall_id'),
        dns_firewall_ips=pulumi.get(__response__, 'dns_firewall_ips'),
        ecs_fallback=pulumi.get(__response__, 'ecs_fallback'),
        id=pulumi.get(__response__, 'id'),
        maximum_cache_ttl=pulumi.get(__response__, 'maximum_cache_ttl'),
        minimum_cache_ttl=pulumi.get(__response__, 'minimum_cache_ttl'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        negative_cache_ttl=pulumi.get(__response__, 'negative_cache_ttl'),
        ratelimit=pulumi.get(__response__, 'ratelimit'),
        retries=pulumi.get(__response__, 'retries'),
        upstream_ips=pulumi.get(__response__, 'upstream_ips')))
