# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDnsZoneTransfersPeerResult',
    'AwaitableGetDnsZoneTransfersPeerResult',
    'get_dns_zone_transfers_peer',
    'get_dns_zone_transfers_peer_output',
]

@pulumi.output_type
class GetDnsZoneTransfersPeerResult:
    """
    A collection of values returned by getDnsZoneTransfersPeer.
    """
    def __init__(__self__, account_id=None, id=None, ip=None, ixfr_enable=None, name=None, peer_id=None, port=None, tsig_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ixfr_enable and not isinstance(ixfr_enable, bool):
            raise TypeError("Expected argument 'ixfr_enable' to be a bool")
        pulumi.set(__self__, "ixfr_enable", ixfr_enable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peer_id and not isinstance(peer_id, str):
            raise TypeError("Expected argument 'peer_id' to be a str")
        pulumi.set(__self__, "peer_id", peer_id)
        if port and not isinstance(port, float):
            raise TypeError("Expected argument 'port' to be a float")
        pulumi.set(__self__, "port", port)
        if tsig_id and not isinstance(tsig_id, str):
            raise TypeError("Expected argument 'tsig_id' to be a str")
        pulumi.set(__self__, "tsig_id", tsig_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        IPv4/IPv6 address of primary or secondary nameserver, depending on what zone this peer is linked to. For primary zones this IP defines the IP of the secondary nameserver Cloudflare will NOTIFY upon zone changes. For secondary zones this IP defines the IP of the primary nameserver Cloudflare will send AXFR/IXFR requests to.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ixfrEnable")
    def ixfr_enable(self) -> builtins.bool:
        """
        Enable IXFR transfer protocol, default is AXFR. Only applicable to secondary zones.
        """
        return pulumi.get(self, "ixfr_enable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the peer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter
    def port(self) -> builtins.float:
        """
        DNS port of primary or secondary nameserver, depending on what zone this peer is linked to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tsigId")
    def tsig_id(self) -> builtins.str:
        """
        TSIG authentication will be used for zone transfer if configured.
        """
        return pulumi.get(self, "tsig_id")


class AwaitableGetDnsZoneTransfersPeerResult(GetDnsZoneTransfersPeerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsZoneTransfersPeerResult(
            account_id=self.account_id,
            id=self.id,
            ip=self.ip,
            ixfr_enable=self.ixfr_enable,
            name=self.name,
            peer_id=self.peer_id,
            port=self.port,
            tsig_id=self.tsig_id)


def get_dns_zone_transfers_peer(account_id: Optional[builtins.str] = None,
                                peer_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsZoneTransfersPeerResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_dns_zone_transfers_peer = cloudflare.get_dns_zone_transfers_peer(account_id="01a7362d577a6c3019a474fd6f485823",
        peer_id="23ff594956f20c2a721606e94745a8aa")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['peerId'] = peer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getDnsZoneTransfersPeer:getDnsZoneTransfersPeer', __args__, opts=opts, typ=GetDnsZoneTransfersPeerResult).value

    return AwaitableGetDnsZoneTransfersPeerResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ixfr_enable=pulumi.get(__ret__, 'ixfr_enable'),
        name=pulumi.get(__ret__, 'name'),
        peer_id=pulumi.get(__ret__, 'peer_id'),
        port=pulumi.get(__ret__, 'port'),
        tsig_id=pulumi.get(__ret__, 'tsig_id'))
def get_dns_zone_transfers_peer_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                       peer_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsZoneTransfersPeerResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_dns_zone_transfers_peer = cloudflare.get_dns_zone_transfers_peer(account_id="01a7362d577a6c3019a474fd6f485823",
        peer_id="23ff594956f20c2a721606e94745a8aa")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['peerId'] = peer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getDnsZoneTransfersPeer:getDnsZoneTransfersPeer', __args__, opts=opts, typ=GetDnsZoneTransfersPeerResult)
    return __ret__.apply(lambda __response__: GetDnsZoneTransfersPeerResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ixfr_enable=pulumi.get(__response__, 'ixfr_enable'),
        name=pulumi.get(__response__, 'name'),
        peer_id=pulumi.get(__response__, 'peer_id'),
        port=pulumi.get(__response__, 'port'),
        tsig_id=pulumi.get(__response__, 'tsig_id')))
