# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEmailRoutingDnsResult',
    'AwaitableGetEmailRoutingDnsResult',
    'get_email_routing_dns',
    'get_email_routing_dns_output',
]

@pulumi.output_type
class GetEmailRoutingDnsResult:
    """
    A collection of values returned by getEmailRoutingDns.
    """
    def __init__(__self__, errors=None, id=None, messages=None, result=None, result_info=None, subdomain=None, success=None, zone_id=None):
        if errors and not isinstance(errors, list):
            raise TypeError("Expected argument 'errors' to be a list")
        pulumi.set(__self__, "errors", errors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if messages and not isinstance(messages, list):
            raise TypeError("Expected argument 'messages' to be a list")
        pulumi.set(__self__, "messages", messages)
        if result and not isinstance(result, dict):
            raise TypeError("Expected argument 'result' to be a dict")
        pulumi.set(__self__, "result", result)
        if result_info and not isinstance(result_info, dict):
            raise TypeError("Expected argument 'result_info' to be a dict")
        pulumi.set(__self__, "result_info", result_info)
        if subdomain and not isinstance(subdomain, str):
            raise TypeError("Expected argument 'subdomain' to be a str")
        pulumi.set(__self__, "subdomain", subdomain)
        if success and not isinstance(success, bool):
            raise TypeError("Expected argument 'success' to be a bool")
        pulumi.set(__self__, "success", success)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.GetEmailRoutingDnsErrorResult']:
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.GetEmailRoutingDnsMessageResult']:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def result(self) -> 'outputs.GetEmailRoutingDnsResultResult':
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="resultInfo")
    def result_info(self) -> 'outputs.GetEmailRoutingDnsResultInfoResult':
        return pulumi.get(self, "result_info")

    @property
    @pulumi.getter
    def subdomain(self) -> Optional[builtins.str]:
        """
        Domain of your zone.
        """
        return pulumi.get(self, "subdomain")

    @property
    @pulumi.getter
    def success(self) -> builtins.bool:
        """
        Whether the API call was successful.
        """
        return pulumi.get(self, "success")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetEmailRoutingDnsResult(GetEmailRoutingDnsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailRoutingDnsResult(
            errors=self.errors,
            id=self.id,
            messages=self.messages,
            result=self.result,
            result_info=self.result_info,
            subdomain=self.subdomain,
            success=self.success,
            zone_id=self.zone_id)


def get_email_routing_dns(subdomain: Optional[builtins.str] = None,
                          zone_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailRoutingDnsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_routing_dns = cloudflare.get_email_routing_dns(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        subdomain="example.net")
    ```


    :param builtins.str subdomain: Domain of your zone.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['subdomain'] = subdomain
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getEmailRoutingDns:getEmailRoutingDns', __args__, opts=opts, typ=GetEmailRoutingDnsResult).value

    return AwaitableGetEmailRoutingDnsResult(
        errors=pulumi.get(__ret__, 'errors'),
        id=pulumi.get(__ret__, 'id'),
        messages=pulumi.get(__ret__, 'messages'),
        result=pulumi.get(__ret__, 'result'),
        result_info=pulumi.get(__ret__, 'result_info'),
        subdomain=pulumi.get(__ret__, 'subdomain'),
        success=pulumi.get(__ret__, 'success'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_email_routing_dns_output(subdomain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailRoutingDnsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_routing_dns = cloudflare.get_email_routing_dns(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        subdomain="example.net")
    ```


    :param builtins.str subdomain: Domain of your zone.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['subdomain'] = subdomain
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getEmailRoutingDns:getEmailRoutingDns', __args__, opts=opts, typ=GetEmailRoutingDnsResult)
    return __ret__.apply(lambda __response__: GetEmailRoutingDnsResult(
        errors=pulumi.get(__response__, 'errors'),
        id=pulumi.get(__response__, 'id'),
        messages=pulumi.get(__response__, 'messages'),
        result=pulumi.get(__response__, 'result'),
        result_info=pulumi.get(__response__, 'result_info'),
        subdomain=pulumi.get(__response__, 'subdomain'),
        success=pulumi.get(__response__, 'success'),
        zone_id=pulumi.get(__response__, 'zone_id')))
