# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEmailSecurityBlockSenderResult',
    'AwaitableGetEmailSecurityBlockSenderResult',
    'get_email_security_block_sender',
    'get_email_security_block_sender_output',
]

@pulumi.output_type
class GetEmailSecurityBlockSenderResult:
    """
    A collection of values returned by getEmailSecurityBlockSender.
    """
    def __init__(__self__, account_id=None, comments=None, created_at=None, filter=None, id=None, is_regex=None, last_modified=None, pattern=None, pattern_id=None, pattern_type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if comments and not isinstance(comments, str):
            raise TypeError("Expected argument 'comments' to be a str")
        pulumi.set(__self__, "comments", comments)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if is_regex and not isinstance(is_regex, bool):
            raise TypeError("Expected argument 'is_regex' to be a bool")
        pulumi.set(__self__, "is_regex", is_regex)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if pattern_id and not isinstance(pattern_id, int):
            raise TypeError("Expected argument 'pattern_id' to be a int")
        pulumi.set(__self__, "pattern_id", pattern_id)
        if pattern_type and not isinstance(pattern_type, str):
            raise TypeError("Expected argument 'pattern_type' to be a str")
        pulumi.set(__self__, "pattern_type", pattern_type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def comments(self) -> builtins.str:
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetEmailSecurityBlockSenderFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        """
        The unique identifier for the allow policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isRegex")
    def is_regex(self) -> builtins.bool:
        return pulumi.get(self, "is_regex")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> builtins.str:
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def pattern(self) -> builtins.str:
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="patternId")
    def pattern_id(self) -> Optional[builtins.int]:
        """
        The unique identifier for the allow policy.
        """
        return pulumi.get(self, "pattern_id")

    @property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> builtins.str:
        """
        Available values: "EMAIL", "DOMAIN", "IP", "UNKNOWN".
        """
        return pulumi.get(self, "pattern_type")


class AwaitableGetEmailSecurityBlockSenderResult(GetEmailSecurityBlockSenderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailSecurityBlockSenderResult(
            account_id=self.account_id,
            comments=self.comments,
            created_at=self.created_at,
            filter=self.filter,
            id=self.id,
            is_regex=self.is_regex,
            last_modified=self.last_modified,
            pattern=self.pattern,
            pattern_id=self.pattern_id,
            pattern_type=self.pattern_type)


def get_email_security_block_sender(account_id: Optional[builtins.str] = None,
                                    filter: Optional[Union['GetEmailSecurityBlockSenderFilterArgs', 'GetEmailSecurityBlockSenderFilterArgsDict']] = None,
                                    pattern_id: Optional[builtins.int] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailSecurityBlockSenderResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_security_block_sender = cloudflare.get_email_security_block_sender(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        pattern_id=2402)
    ```


    :param builtins.str account_id: Account Identifier
    :param builtins.int pattern_id: The unique identifier for the allow policy.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['patternId'] = pattern_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getEmailSecurityBlockSender:getEmailSecurityBlockSender', __args__, opts=opts, typ=GetEmailSecurityBlockSenderResult).value

    return AwaitableGetEmailSecurityBlockSenderResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        comments=pulumi.get(__ret__, 'comments'),
        created_at=pulumi.get(__ret__, 'created_at'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        is_regex=pulumi.get(__ret__, 'is_regex'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        pattern=pulumi.get(__ret__, 'pattern'),
        pattern_id=pulumi.get(__ret__, 'pattern_id'),
        pattern_type=pulumi.get(__ret__, 'pattern_type'))
def get_email_security_block_sender_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                           filter: Optional[pulumi.Input[Optional[Union['GetEmailSecurityBlockSenderFilterArgs', 'GetEmailSecurityBlockSenderFilterArgsDict']]]] = None,
                                           pattern_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailSecurityBlockSenderResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_email_security_block_sender = cloudflare.get_email_security_block_sender(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        pattern_id=2402)
    ```


    :param builtins.str account_id: Account Identifier
    :param builtins.int pattern_id: The unique identifier for the allow policy.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['patternId'] = pattern_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getEmailSecurityBlockSender:getEmailSecurityBlockSender', __args__, opts=opts, typ=GetEmailSecurityBlockSenderResult)
    return __ret__.apply(lambda __response__: GetEmailSecurityBlockSenderResult(
        account_id=pulumi.get(__response__, 'account_id'),
        comments=pulumi.get(__response__, 'comments'),
        created_at=pulumi.get(__response__, 'created_at'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        is_regex=pulumi.get(__response__, 'is_regex'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        pattern=pulumi.get(__response__, 'pattern'),
        pattern_id=pulumi.get(__response__, 'pattern_id'),
        pattern_type=pulumi.get(__response__, 'pattern_type')))
