# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFilterResult',
    'AwaitableGetFilterResult',
    'get_filter',
    'get_filter_output',
]

@pulumi.output_type
class GetFilterResult:
    """
    A collection of values returned by getFilter.
    """
    def __init__(__self__, description=None, expression=None, filter=None, filter_id=None, id=None, paused=None, ref=None, zone_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expression and not isinstance(expression, str):
            raise TypeError("Expected argument 'expression' to be a str")
        pulumi.set(__self__, "expression", expression)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if filter_id and not isinstance(filter_id, str):
            raise TypeError("Expected argument 'filter_id' to be a str")
        pulumi.set(__self__, "filter_id", filter_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if ref and not isinstance(ref, str):
            raise TypeError("Expected argument 'ref' to be a str")
        pulumi.set(__self__, "ref", ref)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An informative summary of the filter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        The filter expression. For more information, refer to [Expressions](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/).
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetFilterFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterId")
    def filter_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the filter.
        """
        return pulumi.get(self, "filter_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier of the filter.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def paused(self) -> builtins.bool:
        """
        When true, indicates that the filter is currently paused.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def ref(self) -> builtins.str:
        """
        A short reference tag. Allows you to select related filters.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetFilterResult(GetFilterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFilterResult(
            description=self.description,
            expression=self.expression,
            filter=self.filter,
            filter_id=self.filter_id,
            id=self.id,
            paused=self.paused,
            ref=self.ref,
            zone_id=self.zone_id)


def get_filter(filter: Optional[Union['GetFilterFilterArgs', 'GetFilterFilterArgsDict']] = None,
               filter_id: Optional[builtins.str] = None,
               zone_id: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFilterResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_filter = cloudflare.get_filter(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        filter_id="372e67954025e0ba6aaa6d586b9e0b61")
    ```


    :param builtins.str filter_id: The unique identifier of the filter.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['filterId'] = filter_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getFilter:getFilter', __args__, opts=opts, typ=GetFilterResult).value

    return AwaitableGetFilterResult(
        description=pulumi.get(__ret__, 'description'),
        expression=pulumi.get(__ret__, 'expression'),
        filter=pulumi.get(__ret__, 'filter'),
        filter_id=pulumi.get(__ret__, 'filter_id'),
        id=pulumi.get(__ret__, 'id'),
        paused=pulumi.get(__ret__, 'paused'),
        ref=pulumi.get(__ret__, 'ref'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_filter_output(filter: Optional[pulumi.Input[Optional[Union['GetFilterFilterArgs', 'GetFilterFilterArgsDict']]]] = None,
                      filter_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      zone_id: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFilterResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_filter = cloudflare.get_filter(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        filter_id="372e67954025e0ba6aaa6d586b9e0b61")
    ```


    :param builtins.str filter_id: The unique identifier of the filter.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['filterId'] = filter_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getFilter:getFilter', __args__, opts=opts, typ=GetFilterResult)
    return __ret__.apply(lambda __response__: GetFilterResult(
        description=pulumi.get(__response__, 'description'),
        expression=pulumi.get(__response__, 'expression'),
        filter=pulumi.get(__response__, 'filter'),
        filter_id=pulumi.get(__response__, 'filter_id'),
        id=pulumi.get(__response__, 'id'),
        paused=pulumi.get(__response__, 'paused'),
        ref=pulumi.get(__response__, 'ref'),
        zone_id=pulumi.get(__response__, 'zone_id')))
