# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFirewallRuleResult',
    'AwaitableGetFirewallRuleResult',
    'get_firewall_rule',
    'get_firewall_rule_output',
]

@pulumi.output_type
class GetFirewallRuleResult:
    """
    A collection of values returned by getFirewallRule.
    """
    def __init__(__self__, action=None, description=None, id=None, paused=None, priority=None, products=None, ref=None, rule_id=None, zone_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if priority and not isinstance(priority, float):
            raise TypeError("Expected argument 'priority' to be a float")
        pulumi.set(__self__, "priority", priority)
        if products and not isinstance(products, list):
            raise TypeError("Expected argument 'products' to be a list")
        pulumi.set(__self__, "products", products)
        if ref and not isinstance(ref, str):
            raise TypeError("Expected argument 'ref' to be a str")
        pulumi.set(__self__, "ref", ref)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        The action to apply to a matched request. The `log` action is only available on an Enterprise plan.
        Available values: "block", "challenge", "js*challenge", "managed*challenge", "allow", "log", "bypass".
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An informative summary of the firewall rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier of the firewall rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def paused(self) -> builtins.bool:
        """
        When true, indicates that the firewall rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def priority(self) -> builtins.float:
        """
        The priority of the rule. Optional value used to define the processing order. A lower number indicates a higher priority. If not provided, rules with a defined priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def products(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "products")

    @property
    @pulumi.getter
    def ref(self) -> builtins.str:
        """
        A short reference tag. Allows you to select related firewall rules.
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the firewall rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetFirewallRuleResult(GetFirewallRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallRuleResult(
            action=self.action,
            description=self.description,
            id=self.id,
            paused=self.paused,
            priority=self.priority,
            products=self.products,
            ref=self.ref,
            rule_id=self.rule_id,
            zone_id=self.zone_id)


def get_firewall_rule(rule_id: Optional[builtins.str] = None,
                      zone_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallRuleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_firewall_rule = cloudflare.get_firewall_rule(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        rule_id="372e67954025e0ba6aaa6d586b9e0b60")
    ```


    :param builtins.str rule_id: The unique identifier of the firewall rule.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['ruleId'] = rule_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getFirewallRule:getFirewallRule', __args__, opts=opts, typ=GetFirewallRuleResult).value

    return AwaitableGetFirewallRuleResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        paused=pulumi.get(__ret__, 'paused'),
        priority=pulumi.get(__ret__, 'priority'),
        products=pulumi.get(__ret__, 'products'),
        ref=pulumi.get(__ret__, 'ref'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_firewall_rule_output(rule_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             zone_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallRuleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_firewall_rule = cloudflare.get_firewall_rule(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        rule_id="372e67954025e0ba6aaa6d586b9e0b60")
    ```


    :param builtins.str rule_id: The unique identifier of the firewall rule.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['ruleId'] = rule_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getFirewallRule:getFirewallRule', __args__, opts=opts, typ=GetFirewallRuleResult)
    return __ret__.apply(lambda __response__: GetFirewallRuleResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        paused=pulumi.get(__response__, 'paused'),
        priority=pulumi.get(__response__, 'priority'),
        products=pulumi.get(__response__, 'products'),
        ref=pulumi.get(__response__, 'ref'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
