# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFirewallRulesResult',
    'AwaitableGetFirewallRulesResult',
    'get_firewall_rules',
    'get_firewall_rules_output',
]

@pulumi.output_type
class GetFirewallRulesResult:
    """
    A collection of values returned by getFirewallRules.
    """
    def __init__(__self__, action=None, description=None, id=None, max_items=None, paused=None, results=None, zone_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[builtins.str]:
        """
        The action to search for. Must be an exact match.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A case-insensitive string to find in the description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the firewall rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def paused(self) -> Optional[builtins.bool]:
        """
        When true, indicates that the firewall rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetFirewallRulesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetFirewallRulesResult(GetFirewallRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallRulesResult(
            action=self.action,
            description=self.description,
            id=self.id,
            max_items=self.max_items,
            paused=self.paused,
            results=self.results,
            zone_id=self.zone_id)


def get_firewall_rules(action: Optional[builtins.str] = None,
                       description: Optional[builtins.str] = None,
                       id: Optional[builtins.str] = None,
                       max_items: Optional[builtins.int] = None,
                       paused: Optional[builtins.bool] = None,
                       zone_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallRulesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_firewall_rules = cloudflare.get_firewall_rules(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="372e67954025e0ba6aaa6d586b9e0b60",
        action="block",
        description="mir",
        paused=False)
    ```


    :param builtins.str action: The action to search for. Must be an exact match.
    :param builtins.str description: A case-insensitive string to find in the description.
    :param builtins.str id: The unique identifier of the firewall rule.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.bool paused: When true, indicates that the firewall rule is currently paused.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['description'] = description
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['paused'] = paused
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getFirewallRules:getFirewallRules', __args__, opts=opts, typ=GetFirewallRulesResult).value

    return AwaitableGetFirewallRulesResult(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        paused=pulumi.get(__ret__, 'paused'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_firewall_rules_output(action: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                              paused: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                              zone_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallRulesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_firewall_rules = cloudflare.get_firewall_rules(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="372e67954025e0ba6aaa6d586b9e0b60",
        action="block",
        description="mir",
        paused=False)
    ```


    :param builtins.str action: The action to search for. Must be an exact match.
    :param builtins.str description: A case-insensitive string to find in the description.
    :param builtins.str id: The unique identifier of the firewall rule.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.bool paused: When true, indicates that the firewall rule is currently paused.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['description'] = description
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['paused'] = paused
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getFirewallRules:getFirewallRules', __args__, opts=opts, typ=GetFirewallRulesResult)
    return __ret__.apply(lambda __response__: GetFirewallRulesResult(
        action=pulumi.get(__response__, 'action'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        paused=pulumi.get(__response__, 'paused'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
