# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, account_id=None, filename=None, id=None, image_id=None, meta=None, require_signed_urls=None, uploaded=None, variants=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if filename and not isinstance(filename, str):
            raise TypeError("Expected argument 'filename' to be a str")
        pulumi.set(__self__, "filename", filename)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if meta and not isinstance(meta, str):
            raise TypeError("Expected argument 'meta' to be a str")
        pulumi.set(__self__, "meta", meta)
        if require_signed_urls and not isinstance(require_signed_urls, bool):
            raise TypeError("Expected argument 'require_signed_urls' to be a bool")
        pulumi.set(__self__, "require_signed_urls", require_signed_urls)
        if uploaded and not isinstance(uploaded, str):
            raise TypeError("Expected argument 'uploaded' to be a str")
        pulumi.set(__self__, "uploaded", uploaded)
        if variants and not isinstance(variants, list):
            raise TypeError("Expected argument 'variants' to be a list")
        pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def filename(self) -> builtins.str:
        """
        Image file name.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Image unique identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        Image unique identifier.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def meta(self) -> builtins.str:
        """
        User modifiable key-value store. Can be used for keeping references to another system of record for managing images. Metadata must not exceed 1024 bytes.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> builtins.bool:
        """
        Indicates whether the image can be a accessed only using it's UID. If set to true, a signed token needs to be generated with a signing key to view the image.
        """
        return pulumi.get(self, "require_signed_urls")

    @property
    @pulumi.getter
    def uploaded(self) -> builtins.str:
        """
        When the media item was uploaded.
        """
        return pulumi.get(self, "uploaded")

    @property
    @pulumi.getter
    def variants(self) -> Sequence[builtins.str]:
        """
        Object specifying available variants for an image.
        """
        return pulumi.get(self, "variants")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            account_id=self.account_id,
            filename=self.filename,
            id=self.id,
            image_id=self.image_id,
            meta=self.meta,
            require_signed_urls=self.require_signed_urls,
            uploaded=self.uploaded,
            variants=self.variants)


def get_image(account_id: Optional[builtins.str] = None,
              image_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_image = cloudflare.get_image(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        image_id="image_id")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str image_id: Image unique identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        filename=pulumi.get(__ret__, 'filename'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        meta=pulumi.get(__ret__, 'meta'),
        require_signed_urls=pulumi.get(__ret__, 'require_signed_urls'),
        uploaded=pulumi.get(__ret__, 'uploaded'),
        variants=pulumi.get(__ret__, 'variants'))
def get_image_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                     image_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_image = cloudflare.get_image(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        image_id="image_id")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str image_id: Image unique identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        account_id=pulumi.get(__response__, 'account_id'),
        filename=pulumi.get(__response__, 'filename'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        meta=pulumi.get(__response__, 'meta'),
        require_signed_urls=pulumi.get(__response__, 'require_signed_urls'),
        uploaded=pulumi.get(__response__, 'uploaded'),
        variants=pulumi.get(__response__, 'variants')))
