# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIpRangesResult',
    'AwaitableGetIpRangesResult',
    'get_ip_ranges',
    'get_ip_ranges_output',
]

@pulumi.output_type
class GetIpRangesResult:
    """
    A collection of values returned by getIpRanges.
    """
    def __init__(__self__, etag=None, id=None, ipv4_cidrs=None, ipv6_cidrs=None, jdcloud_cidrs=None, networks=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4_cidrs and not isinstance(ipv4_cidrs, list):
            raise TypeError("Expected argument 'ipv4_cidrs' to be a list")
        pulumi.set(__self__, "ipv4_cidrs", ipv4_cidrs)
        if ipv6_cidrs and not isinstance(ipv6_cidrs, list):
            raise TypeError("Expected argument 'ipv6_cidrs' to be a list")
        pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)
        if jdcloud_cidrs and not isinstance(jdcloud_cidrs, list):
            raise TypeError("Expected argument 'jdcloud_cidrs' to be a list")
        pulumi.set(__self__, "jdcloud_cidrs", jdcloud_cidrs)
        if networks and not isinstance(networks, str):
            raise TypeError("Expected argument 'networks' to be a str")
        pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        A digest of the IP data. Useful for determining if the data has changed.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv4Cidrs")
    def ipv4_cidrs(self) -> Sequence[builtins.str]:
        """
        List of Cloudflare IPv4 CIDR addresses.
        """
        return pulumi.get(self, "ipv4_cidrs")

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Sequence[builtins.str]:
        """
        List of Cloudflare IPv6 CIDR addresses.
        """
        return pulumi.get(self, "ipv6_cidrs")

    @property
    @pulumi.getter(name="jdcloudCidrs")
    def jdcloud_cidrs(self) -> Sequence[builtins.str]:
        """
        List IPv4 and IPv6 CIDRs, only populated if `?networks=jdcloud` is used.
        """
        return pulumi.get(self, "jdcloud_cidrs")

    @property
    @pulumi.getter
    def networks(self) -> Optional[builtins.str]:
        """
        Specified as `jdcloud` to list IPs used by JD Cloud data centers.
        """
        return pulumi.get(self, "networks")


class AwaitableGetIpRangesResult(GetIpRangesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpRangesResult(
            etag=self.etag,
            id=self.id,
            ipv4_cidrs=self.ipv4_cidrs,
            ipv6_cidrs=self.ipv6_cidrs,
            jdcloud_cidrs=self.jdcloud_cidrs,
            networks=self.networks)


def get_ip_ranges(networks: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpRangesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_ip_ranges = cloudflare.get_ip_ranges(networks="networks")
    ```


    :param builtins.str networks: Specified as `jdcloud` to list IPs used by JD Cloud data centers.
    """
    __args__ = dict()
    __args__['networks'] = networks
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getIpRanges:getIpRanges', __args__, opts=opts, typ=GetIpRangesResult).value

    return AwaitableGetIpRangesResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        ipv4_cidrs=pulumi.get(__ret__, 'ipv4_cidrs'),
        ipv6_cidrs=pulumi.get(__ret__, 'ipv6_cidrs'),
        jdcloud_cidrs=pulumi.get(__ret__, 'jdcloud_cidrs'),
        networks=pulumi.get(__ret__, 'networks'))
def get_ip_ranges_output(networks: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpRangesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_ip_ranges = cloudflare.get_ip_ranges(networks="networks")
    ```


    :param builtins.str networks: Specified as `jdcloud` to list IPs used by JD Cloud data centers.
    """
    __args__ = dict()
    __args__['networks'] = networks
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getIpRanges:getIpRanges', __args__, opts=opts, typ=GetIpRangesResult)
    return __ret__.apply(lambda __response__: GetIpRangesResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        ipv4_cidrs=pulumi.get(__response__, 'ipv4_cidrs'),
        ipv6_cidrs=pulumi.get(__response__, 'ipv6_cidrs'),
        jdcloud_cidrs=pulumi.get(__response__, 'jdcloud_cidrs'),
        networks=pulumi.get(__response__, 'networks')))
