# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLoadBalancerResult',
    'AwaitableGetLoadBalancerResult',
    'get_load_balancer',
    'get_load_balancer_output',
]

@pulumi.output_type
class GetLoadBalancerResult:
    """
    A collection of values returned by getLoadBalancer.
    """
    def __init__(__self__, adaptive_routing=None, country_pools=None, created_on=None, default_pools=None, description=None, enabled=None, fallback_pool=None, id=None, load_balancer_id=None, location_strategy=None, modified_on=None, name=None, networks=None, pop_pools=None, proxied=None, random_steering=None, region_pools=None, rules=None, session_affinity=None, session_affinity_attributes=None, session_affinity_ttl=None, steering_policy=None, ttl=None, zone_id=None):
        if adaptive_routing and not isinstance(adaptive_routing, dict):
            raise TypeError("Expected argument 'adaptive_routing' to be a dict")
        pulumi.set(__self__, "adaptive_routing", adaptive_routing)
        if country_pools and not isinstance(country_pools, dict):
            raise TypeError("Expected argument 'country_pools' to be a dict")
        pulumi.set(__self__, "country_pools", country_pools)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if default_pools and not isinstance(default_pools, list):
            raise TypeError("Expected argument 'default_pools' to be a list")
        pulumi.set(__self__, "default_pools", default_pools)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if fallback_pool and not isinstance(fallback_pool, str):
            raise TypeError("Expected argument 'fallback_pool' to be a str")
        pulumi.set(__self__, "fallback_pool", fallback_pool)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if location_strategy and not isinstance(location_strategy, dict):
            raise TypeError("Expected argument 'location_strategy' to be a dict")
        pulumi.set(__self__, "location_strategy", location_strategy)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if pop_pools and not isinstance(pop_pools, dict):
            raise TypeError("Expected argument 'pop_pools' to be a dict")
        pulumi.set(__self__, "pop_pools", pop_pools)
        if proxied and not isinstance(proxied, bool):
            raise TypeError("Expected argument 'proxied' to be a bool")
        pulumi.set(__self__, "proxied", proxied)
        if random_steering and not isinstance(random_steering, dict):
            raise TypeError("Expected argument 'random_steering' to be a dict")
        pulumi.set(__self__, "random_steering", random_steering)
        if region_pools and not isinstance(region_pools, dict):
            raise TypeError("Expected argument 'region_pools' to be a dict")
        pulumi.set(__self__, "region_pools", region_pools)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if session_affinity and not isinstance(session_affinity, str):
            raise TypeError("Expected argument 'session_affinity' to be a str")
        pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_attributes and not isinstance(session_affinity_attributes, dict):
            raise TypeError("Expected argument 'session_affinity_attributes' to be a dict")
        pulumi.set(__self__, "session_affinity_attributes", session_affinity_attributes)
        if session_affinity_ttl and not isinstance(session_affinity_ttl, float):
            raise TypeError("Expected argument 'session_affinity_ttl' to be a float")
        pulumi.set(__self__, "session_affinity_ttl", session_affinity_ttl)
        if steering_policy and not isinstance(steering_policy, str):
            raise TypeError("Expected argument 'steering_policy' to be a str")
        pulumi.set(__self__, "steering_policy", steering_policy)
        if ttl and not isinstance(ttl, float):
            raise TypeError("Expected argument 'ttl' to be a float")
        pulumi.set(__self__, "ttl", ttl)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> 'outputs.GetLoadBalancerAdaptiveRoutingResult':
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        """
        return pulumi.get(self, "adaptive_routing")

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> Mapping[str, Sequence[builtins.str]]:
        """
        A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        """
        return pulumi.get(self, "country_pools")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> Sequence[builtins.str]:
        """
        A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        """
        return pulumi.get(self, "default_pools")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether to enable (the default) this load balancer.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> builtins.str:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="locationStrategy")
    def location_strategy(self) -> 'outputs.GetLoadBalancerLocationStrategyResult':
        """
        Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        """
        return pulumi.get(self, "location_strategy")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> Sequence[builtins.str]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> Mapping[str, Sequence[builtins.str]]:
        """
        (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        """
        return pulumi.get(self, "pop_pools")

    @property
    @pulumi.getter
    def proxied(self) -> builtins.bool:
        """
        Whether the hostname should be gray clouded (false) or orange clouded (true).
        """
        return pulumi.get(self, "proxied")

    @property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> 'outputs.GetLoadBalancerRandomSteeringResult':
        """
        Configures pool weights.
        """
        return pulumi.get(self, "random_steering")

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Mapping[str, Sequence[builtins.str]]:
        """
        A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        """
        return pulumi.get(self, "region_pools")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetLoadBalancerRuleResult']:
        """
        BETA Field Not General Access: A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> builtins.str:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> 'outputs.GetLoadBalancerSessionAffinityAttributesResult':
        """
        Configures attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> builtins.float:
        """
        Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        """
        return pulumi.get(self, "session_affinity_ttl")

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> builtins.str:
        """
        Steering Policy for this load balancer.
        """
        return pulumi.get(self, "steering_policy")

    @property
    @pulumi.getter
    def ttl(self) -> builtins.float:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        return pulumi.get(self, "zone_id")


class AwaitableGetLoadBalancerResult(GetLoadBalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancerResult(
            adaptive_routing=self.adaptive_routing,
            country_pools=self.country_pools,
            created_on=self.created_on,
            default_pools=self.default_pools,
            description=self.description,
            enabled=self.enabled,
            fallback_pool=self.fallback_pool,
            id=self.id,
            load_balancer_id=self.load_balancer_id,
            location_strategy=self.location_strategy,
            modified_on=self.modified_on,
            name=self.name,
            networks=self.networks,
            pop_pools=self.pop_pools,
            proxied=self.proxied,
            random_steering=self.random_steering,
            region_pools=self.region_pools,
            rules=self.rules,
            session_affinity=self.session_affinity,
            session_affinity_attributes=self.session_affinity_attributes,
            session_affinity_ttl=self.session_affinity_ttl,
            steering_policy=self.steering_policy,
            ttl=self.ttl,
            zone_id=self.zone_id)


def get_load_balancer(load_balancer_id: Optional[builtins.str] = None,
                      pop_pools: Optional[Mapping[str, Sequence[builtins.str]]] = None,
                      region_pools: Optional[Mapping[str, Sequence[builtins.str]]] = None,
                      zone_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancerResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer = cloudflare.get_load_balancer(zone_id="699d98642c564d2e855e9661899b7252",
        load_balancer_id="699d98642c564d2e855e9661899b7252")
    ```


    :param Mapping[str, Sequence[builtins.str]] pop_pools: (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
    :param Mapping[str, Sequence[builtins.str]] region_pools: A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    __args__['popPools'] = pop_pools
    __args__['regionPools'] = region_pools
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLoadBalancer:getLoadBalancer', __args__, opts=opts, typ=GetLoadBalancerResult).value

    return AwaitableGetLoadBalancerResult(
        adaptive_routing=pulumi.get(__ret__, 'adaptive_routing'),
        country_pools=pulumi.get(__ret__, 'country_pools'),
        created_on=pulumi.get(__ret__, 'created_on'),
        default_pools=pulumi.get(__ret__, 'default_pools'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        fallback_pool=pulumi.get(__ret__, 'fallback_pool'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        location_strategy=pulumi.get(__ret__, 'location_strategy'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        networks=pulumi.get(__ret__, 'networks'),
        pop_pools=pulumi.get(__ret__, 'pop_pools'),
        proxied=pulumi.get(__ret__, 'proxied'),
        random_steering=pulumi.get(__ret__, 'random_steering'),
        region_pools=pulumi.get(__ret__, 'region_pools'),
        rules=pulumi.get(__ret__, 'rules'),
        session_affinity=pulumi.get(__ret__, 'session_affinity'),
        session_affinity_attributes=pulumi.get(__ret__, 'session_affinity_attributes'),
        session_affinity_ttl=pulumi.get(__ret__, 'session_affinity_ttl'),
        steering_policy=pulumi.get(__ret__, 'steering_policy'),
        ttl=pulumi.get(__ret__, 'ttl'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_load_balancer_output(load_balancer_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             pop_pools: Optional[pulumi.Input[Optional[Mapping[str, Sequence[builtins.str]]]]] = None,
                             region_pools: Optional[pulumi.Input[Optional[Mapping[str, Sequence[builtins.str]]]]] = None,
                             zone_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancerResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer = cloudflare.get_load_balancer(zone_id="699d98642c564d2e855e9661899b7252",
        load_balancer_id="699d98642c564d2e855e9661899b7252")
    ```


    :param Mapping[str, Sequence[builtins.str]] pop_pools: (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
    :param Mapping[str, Sequence[builtins.str]] region_pools: A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    __args__['popPools'] = pop_pools
    __args__['regionPools'] = region_pools
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLoadBalancer:getLoadBalancer', __args__, opts=opts, typ=GetLoadBalancerResult)
    return __ret__.apply(lambda __response__: GetLoadBalancerResult(
        adaptive_routing=pulumi.get(__response__, 'adaptive_routing'),
        country_pools=pulumi.get(__response__, 'country_pools'),
        created_on=pulumi.get(__response__, 'created_on'),
        default_pools=pulumi.get(__response__, 'default_pools'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        fallback_pool=pulumi.get(__response__, 'fallback_pool'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        location_strategy=pulumi.get(__response__, 'location_strategy'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        networks=pulumi.get(__response__, 'networks'),
        pop_pools=pulumi.get(__response__, 'pop_pools'),
        proxied=pulumi.get(__response__, 'proxied'),
        random_steering=pulumi.get(__response__, 'random_steering'),
        region_pools=pulumi.get(__response__, 'region_pools'),
        rules=pulumi.get(__response__, 'rules'),
        session_affinity=pulumi.get(__response__, 'session_affinity'),
        session_affinity_attributes=pulumi.get(__response__, 'session_affinity_attributes'),
        session_affinity_ttl=pulumi.get(__response__, 'session_affinity_ttl'),
        steering_policy=pulumi.get(__response__, 'steering_policy'),
        ttl=pulumi.get(__response__, 'ttl'),
        zone_id=pulumi.get(__response__, 'zone_id')))
