# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLoadBalancerPoolsResult',
    'AwaitableGetLoadBalancerPoolsResult',
    'get_load_balancer_pools',
    'get_load_balancer_pools_output',
]

@pulumi.output_type
class GetLoadBalancerPoolsResult:
    """
    A collection of values returned by getLoadBalancerPools.
    """
    def __init__(__self__, account_id=None, id=None, max_items=None, monitor=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if monitor and not isinstance(monitor, str):
            raise TypeError("Expected argument 'monitor' to be a str")
        pulumi.set(__self__, "monitor", monitor)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def monitor(self) -> Optional[builtins.str]:
        """
        The ID of the Monitor to use for checking the health of origins within this pool.
        """
        return pulumi.get(self, "monitor")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetLoadBalancerPoolsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetLoadBalancerPoolsResult(GetLoadBalancerPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancerPoolsResult(
            account_id=self.account_id,
            id=self.id,
            max_items=self.max_items,
            monitor=self.monitor,
            results=self.results)


def get_load_balancer_pools(account_id: Optional[builtins.str] = None,
                            max_items: Optional[builtins.int] = None,
                            monitor: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancerPoolsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer_pools = cloudflare.get_load_balancer_pools(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        monitor="monitor")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str monitor: The ID of the Monitor to use for checking the health of origins within this pool.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['monitor'] = monitor
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLoadBalancerPools:getLoadBalancerPools', __args__, opts=opts, typ=GetLoadBalancerPoolsResult).value

    return AwaitableGetLoadBalancerPoolsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        monitor=pulumi.get(__ret__, 'monitor'),
        results=pulumi.get(__ret__, 'results'))
def get_load_balancer_pools_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                   max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                   monitor: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancerPoolsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_load_balancer_pools = cloudflare.get_load_balancer_pools(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        monitor="monitor")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str monitor: The ID of the Monitor to use for checking the health of origins within this pool.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['monitor'] = monitor
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLoadBalancerPools:getLoadBalancerPools', __args__, opts=opts, typ=GetLoadBalancerPoolsResult)
    return __ret__.apply(lambda __response__: GetLoadBalancerPoolsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        monitor=pulumi.get(__response__, 'monitor'),
        results=pulumi.get(__response__, 'results')))
