# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMagicNetworkMonitoringConfigurationResult',
    'AwaitableGetMagicNetworkMonitoringConfigurationResult',
    'get_magic_network_monitoring_configuration',
    'get_magic_network_monitoring_configuration_output',
]

@pulumi.output_type
class GetMagicNetworkMonitoringConfigurationResult:
    """
    A collection of values returned by getMagicNetworkMonitoringConfiguration.
    """
    def __init__(__self__, account_id=None, default_sampling=None, id=None, name=None, router_ips=None, warp_devices=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if default_sampling and not isinstance(default_sampling, float):
            raise TypeError("Expected argument 'default_sampling' to be a float")
        pulumi.set(__self__, "default_sampling", default_sampling)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if router_ips and not isinstance(router_ips, list):
            raise TypeError("Expected argument 'router_ips' to be a list")
        pulumi.set(__self__, "router_ips", router_ips)
        if warp_devices and not isinstance(warp_devices, list):
            raise TypeError("Expected argument 'warp_devices' to be a list")
        pulumi.set(__self__, "warp_devices", warp_devices)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="defaultSampling")
    def default_sampling(self) -> builtins.float:
        """
        Fallback sampling rate of flow messages being sent in packets per second. This should match the packet sampling rate configured on the router.
        """
        return pulumi.get(self, "default_sampling")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The account name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routerIps")
    def router_ips(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "router_ips")

    @property
    @pulumi.getter(name="warpDevices")
    def warp_devices(self) -> Sequence['outputs.GetMagicNetworkMonitoringConfigurationWarpDeviceResult']:
        return pulumi.get(self, "warp_devices")


class AwaitableGetMagicNetworkMonitoringConfigurationResult(GetMagicNetworkMonitoringConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMagicNetworkMonitoringConfigurationResult(
            account_id=self.account_id,
            default_sampling=self.default_sampling,
            id=self.id,
            name=self.name,
            router_ips=self.router_ips,
            warp_devices=self.warp_devices)


def get_magic_network_monitoring_configuration(account_id: Optional[builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMagicNetworkMonitoringConfigurationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_network_monitoring_configuration = cloudflare.get_magic_network_monitoring_configuration(account_id="6f91088a406011ed95aed352566e8d4c")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMagicNetworkMonitoringConfiguration:getMagicNetworkMonitoringConfiguration', __args__, opts=opts, typ=GetMagicNetworkMonitoringConfigurationResult).value

    return AwaitableGetMagicNetworkMonitoringConfigurationResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        default_sampling=pulumi.get(__ret__, 'default_sampling'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        router_ips=pulumi.get(__ret__, 'router_ips'),
        warp_devices=pulumi.get(__ret__, 'warp_devices'))
def get_magic_network_monitoring_configuration_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMagicNetworkMonitoringConfigurationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_network_monitoring_configuration = cloudflare.get_magic_network_monitoring_configuration(account_id="6f91088a406011ed95aed352566e8d4c")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMagicNetworkMonitoringConfiguration:getMagicNetworkMonitoringConfiguration', __args__, opts=opts, typ=GetMagicNetworkMonitoringConfigurationResult)
    return __ret__.apply(lambda __response__: GetMagicNetworkMonitoringConfigurationResult(
        account_id=pulumi.get(__response__, 'account_id'),
        default_sampling=pulumi.get(__response__, 'default_sampling'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        router_ips=pulumi.get(__response__, 'router_ips'),
        warp_devices=pulumi.get(__response__, 'warp_devices')))
