# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMagicTransitConnectorResult',
    'AwaitableGetMagicTransitConnectorResult',
    'get_magic_transit_connector',
    'get_magic_transit_connector_output',
]

@pulumi.output_type
class GetMagicTransitConnectorResult:
    """
    A collection of values returned by getMagicTransitConnector.
    """
    def __init__(__self__, account_id=None, activated=None, connector_id=None, device=None, id=None, interrupt_window_duration_hours=None, interrupt_window_hour_of_day=None, last_heartbeat=None, last_seen_version=None, last_updated=None, notes=None, timezone=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if activated and not isinstance(activated, bool):
            raise TypeError("Expected argument 'activated' to be a bool")
        pulumi.set(__self__, "activated", activated)
        if connector_id and not isinstance(connector_id, str):
            raise TypeError("Expected argument 'connector_id' to be a str")
        pulumi.set(__self__, "connector_id", connector_id)
        if device and not isinstance(device, dict):
            raise TypeError("Expected argument 'device' to be a dict")
        pulumi.set(__self__, "device", device)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interrupt_window_duration_hours and not isinstance(interrupt_window_duration_hours, float):
            raise TypeError("Expected argument 'interrupt_window_duration_hours' to be a float")
        pulumi.set(__self__, "interrupt_window_duration_hours", interrupt_window_duration_hours)
        if interrupt_window_hour_of_day and not isinstance(interrupt_window_hour_of_day, float):
            raise TypeError("Expected argument 'interrupt_window_hour_of_day' to be a float")
        pulumi.set(__self__, "interrupt_window_hour_of_day", interrupt_window_hour_of_day)
        if last_heartbeat and not isinstance(last_heartbeat, str):
            raise TypeError("Expected argument 'last_heartbeat' to be a str")
        pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if last_seen_version and not isinstance(last_seen_version, str):
            raise TypeError("Expected argument 'last_seen_version' to be a str")
        pulumi.set(__self__, "last_seen_version", last_seen_version)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if notes and not isinstance(notes, str):
            raise TypeError("Expected argument 'notes' to be a str")
        pulumi.set(__self__, "notes", notes)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def activated(self) -> builtins.bool:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter
    def device(self) -> 'outputs.GetMagicTransitConnectorDeviceResult':
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interruptWindowDurationHours")
    def interrupt_window_duration_hours(self) -> builtins.float:
        return pulumi.get(self, "interrupt_window_duration_hours")

    @property
    @pulumi.getter(name="interruptWindowHourOfDay")
    def interrupt_window_hour_of_day(self) -> builtins.float:
        return pulumi.get(self, "interrupt_window_hour_of_day")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> builtins.str:
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="lastSeenVersion")
    def last_seen_version(self) -> builtins.str:
        return pulumi.get(self, "last_seen_version")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> builtins.str:
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def notes(self) -> builtins.str:
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def timezone(self) -> builtins.str:
        return pulumi.get(self, "timezone")


class AwaitableGetMagicTransitConnectorResult(GetMagicTransitConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMagicTransitConnectorResult(
            account_id=self.account_id,
            activated=self.activated,
            connector_id=self.connector_id,
            device=self.device,
            id=self.id,
            interrupt_window_duration_hours=self.interrupt_window_duration_hours,
            interrupt_window_hour_of_day=self.interrupt_window_hour_of_day,
            last_heartbeat=self.last_heartbeat,
            last_seen_version=self.last_seen_version,
            last_updated=self.last_updated,
            notes=self.notes,
            timezone=self.timezone)


def get_magic_transit_connector(account_id: Optional[builtins.str] = None,
                                connector_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMagicTransitConnectorResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_connector = cloudflare.get_magic_transit_connector(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        connector_id="connector_id")
    ```


    :param builtins.str account_id: Account identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['connectorId'] = connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMagicTransitConnector:getMagicTransitConnector', __args__, opts=opts, typ=GetMagicTransitConnectorResult).value

    return AwaitableGetMagicTransitConnectorResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        activated=pulumi.get(__ret__, 'activated'),
        connector_id=pulumi.get(__ret__, 'connector_id'),
        device=pulumi.get(__ret__, 'device'),
        id=pulumi.get(__ret__, 'id'),
        interrupt_window_duration_hours=pulumi.get(__ret__, 'interrupt_window_duration_hours'),
        interrupt_window_hour_of_day=pulumi.get(__ret__, 'interrupt_window_hour_of_day'),
        last_heartbeat=pulumi.get(__ret__, 'last_heartbeat'),
        last_seen_version=pulumi.get(__ret__, 'last_seen_version'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        notes=pulumi.get(__ret__, 'notes'),
        timezone=pulumi.get(__ret__, 'timezone'))
def get_magic_transit_connector_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                       connector_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMagicTransitConnectorResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_connector = cloudflare.get_magic_transit_connector(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        connector_id="connector_id")
    ```


    :param builtins.str account_id: Account identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['connectorId'] = connector_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMagicTransitConnector:getMagicTransitConnector', __args__, opts=opts, typ=GetMagicTransitConnectorResult)
    return __ret__.apply(lambda __response__: GetMagicTransitConnectorResult(
        account_id=pulumi.get(__response__, 'account_id'),
        activated=pulumi.get(__response__, 'activated'),
        connector_id=pulumi.get(__response__, 'connector_id'),
        device=pulumi.get(__response__, 'device'),
        id=pulumi.get(__response__, 'id'),
        interrupt_window_duration_hours=pulumi.get(__response__, 'interrupt_window_duration_hours'),
        interrupt_window_hour_of_day=pulumi.get(__response__, 'interrupt_window_hour_of_day'),
        last_heartbeat=pulumi.get(__response__, 'last_heartbeat'),
        last_seen_version=pulumi.get(__response__, 'last_seen_version'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        notes=pulumi.get(__response__, 'notes'),
        timezone=pulumi.get(__response__, 'timezone')))
