# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMagicTransitSiteAclResult',
    'AwaitableGetMagicTransitSiteAclResult',
    'get_magic_transit_site_acl',
    'get_magic_transit_site_acl_output',
]

@pulumi.output_type
class GetMagicTransitSiteAclResult:
    """
    A collection of values returned by getMagicTransitSiteAcl.
    """
    def __init__(__self__, account_id=None, acl_id=None, description=None, forward_locally=None, id=None, lan1=None, lan2=None, name=None, protocols=None, site_id=None, unidirectional=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if acl_id and not isinstance(acl_id, str):
            raise TypeError("Expected argument 'acl_id' to be a str")
        pulumi.set(__self__, "acl_id", acl_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if forward_locally and not isinstance(forward_locally, bool):
            raise TypeError("Expected argument 'forward_locally' to be a bool")
        pulumi.set(__self__, "forward_locally", forward_locally)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lan1 and not isinstance(lan1, dict):
            raise TypeError("Expected argument 'lan1' to be a dict")
        pulumi.set(__self__, "lan1", lan1)
        if lan2 and not isinstance(lan2, dict):
            raise TypeError("Expected argument 'lan2' to be a dict")
        pulumi.set(__self__, "lan2", lan2)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocols and not isinstance(protocols, list):
            raise TypeError("Expected argument 'protocols' to be a list")
        pulumi.set(__self__, "protocols", protocols)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if unidirectional and not isinstance(unidirectional, bool):
            raise TypeError("Expected argument 'unidirectional' to be a bool")
        pulumi.set(__self__, "unidirectional", unidirectional)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description for the ACL.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forwardLocally")
    def forward_locally(self) -> builtins.bool:
        """
        The desired forwarding action for this ACL policy. If set to "false", the policy will forward traffic to Cloudflare. If set to "true", the policy will forward traffic locally on the Magic Connector. If not included in request, will default to false.
        """
        return pulumi.get(self, "forward_locally")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def lan1(self) -> 'outputs.GetMagicTransitSiteAclLan1Result':
        return pulumi.get(self, "lan1")

    @property
    @pulumi.getter
    def lan2(self) -> 'outputs.GetMagicTransitSiteAclLan2Result':
        return pulumi.get(self, "lan2")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the ACL.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def unidirectional(self) -> builtins.bool:
        """
        The desired traffic direction for this ACL policy. If set to "false", the policy will allow bidirectional traffic. If set to "true", the policy will only allow traffic in one direction. If not included in request, will default to false.
        """
        return pulumi.get(self, "unidirectional")


class AwaitableGetMagicTransitSiteAclResult(GetMagicTransitSiteAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMagicTransitSiteAclResult(
            account_id=self.account_id,
            acl_id=self.acl_id,
            description=self.description,
            forward_locally=self.forward_locally,
            id=self.id,
            lan1=self.lan1,
            lan2=self.lan2,
            name=self.name,
            protocols=self.protocols,
            site_id=self.site_id,
            unidirectional=self.unidirectional)


def get_magic_transit_site_acl(account_id: Optional[builtins.str] = None,
                               acl_id: Optional[builtins.str] = None,
                               site_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMagicTransitSiteAclResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_site_acl = cloudflare.get_magic_transit_site_acl(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353",
        acl_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str acl_id: Identifier
    :param builtins.str site_id: Identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['aclId'] = acl_id
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMagicTransitSiteAcl:getMagicTransitSiteAcl', __args__, opts=opts, typ=GetMagicTransitSiteAclResult).value

    return AwaitableGetMagicTransitSiteAclResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        acl_id=pulumi.get(__ret__, 'acl_id'),
        description=pulumi.get(__ret__, 'description'),
        forward_locally=pulumi.get(__ret__, 'forward_locally'),
        id=pulumi.get(__ret__, 'id'),
        lan1=pulumi.get(__ret__, 'lan1'),
        lan2=pulumi.get(__ret__, 'lan2'),
        name=pulumi.get(__ret__, 'name'),
        protocols=pulumi.get(__ret__, 'protocols'),
        site_id=pulumi.get(__ret__, 'site_id'),
        unidirectional=pulumi.get(__ret__, 'unidirectional'))
def get_magic_transit_site_acl_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                      acl_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      site_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMagicTransitSiteAclResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_site_acl = cloudflare.get_magic_transit_site_acl(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353",
        acl_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str acl_id: Identifier
    :param builtins.str site_id: Identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['aclId'] = acl_id
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMagicTransitSiteAcl:getMagicTransitSiteAcl', __args__, opts=opts, typ=GetMagicTransitSiteAclResult)
    return __ret__.apply(lambda __response__: GetMagicTransitSiteAclResult(
        account_id=pulumi.get(__response__, 'account_id'),
        acl_id=pulumi.get(__response__, 'acl_id'),
        description=pulumi.get(__response__, 'description'),
        forward_locally=pulumi.get(__response__, 'forward_locally'),
        id=pulumi.get(__response__, 'id'),
        lan1=pulumi.get(__response__, 'lan1'),
        lan2=pulumi.get(__response__, 'lan2'),
        name=pulumi.get(__response__, 'name'),
        protocols=pulumi.get(__response__, 'protocols'),
        site_id=pulumi.get(__response__, 'site_id'),
        unidirectional=pulumi.get(__response__, 'unidirectional')))
