# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMtlsCertificateResult',
    'AwaitableGetMtlsCertificateResult',
    'get_mtls_certificate',
    'get_mtls_certificate_output',
]

@pulumi.output_type
class GetMtlsCertificateResult:
    """
    A collection of values returned by getMtlsCertificate.
    """
    def __init__(__self__, account_id=None, ca=None, certificates=None, expires_on=None, id=None, issuer=None, mtls_certificate_id=None, name=None, serial_number=None, signature=None, uploaded_on=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if ca and not isinstance(ca, bool):
            raise TypeError("Expected argument 'ca' to be a bool")
        pulumi.set(__self__, "ca", ca)
        if certificates and not isinstance(certificates, str):
            raise TypeError("Expected argument 'certificates' to be a str")
        pulumi.set(__self__, "certificates", certificates)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if mtls_certificate_id and not isinstance(mtls_certificate_id, str):
            raise TypeError("Expected argument 'mtls_certificate_id' to be a str")
        pulumi.set(__self__, "mtls_certificate_id", mtls_certificate_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if signature and not isinstance(signature, str):
            raise TypeError("Expected argument 'signature' to be a str")
        pulumi.set(__self__, "signature", signature)
        if uploaded_on and not isinstance(uploaded_on, str):
            raise TypeError("Expected argument 'uploaded_on' to be a str")
        pulumi.set(__self__, "uploaded_on", uploaded_on)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def ca(self) -> builtins.bool:
        """
        Indicates whether the certificate is a CA or leaf certificate.
        """
        return pulumi.get(self, "ca")

    @property
    @pulumi.getter
    def certificates(self) -> builtins.str:
        """
        The uploaded root CA certificate.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> builtins.str:
        """
        When the certificate expires.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="mtlsCertificateId")
    def mtls_certificate_id(self) -> Optional[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "mtls_certificate_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Optional unique name for the certificate. Only used for human readability.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> builtins.str:
        """
        The certificate serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def signature(self) -> builtins.str:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> builtins.str:
        """
        This is the time the certificate was uploaded.
        """
        return pulumi.get(self, "uploaded_on")


class AwaitableGetMtlsCertificateResult(GetMtlsCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMtlsCertificateResult(
            account_id=self.account_id,
            ca=self.ca,
            certificates=self.certificates,
            expires_on=self.expires_on,
            id=self.id,
            issuer=self.issuer,
            mtls_certificate_id=self.mtls_certificate_id,
            name=self.name,
            serial_number=self.serial_number,
            signature=self.signature,
            uploaded_on=self.uploaded_on)


def get_mtls_certificate(account_id: Optional[builtins.str] = None,
                         mtls_certificate_id: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMtlsCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_mtls_certificate = cloudflare.get_mtls_certificate(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        mtls_certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str mtls_certificate_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['mtlsCertificateId'] = mtls_certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMtlsCertificate:getMtlsCertificate', __args__, opts=opts, typ=GetMtlsCertificateResult).value

    return AwaitableGetMtlsCertificateResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        ca=pulumi.get(__ret__, 'ca'),
        certificates=pulumi.get(__ret__, 'certificates'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        id=pulumi.get(__ret__, 'id'),
        issuer=pulumi.get(__ret__, 'issuer'),
        mtls_certificate_id=pulumi.get(__ret__, 'mtls_certificate_id'),
        name=pulumi.get(__ret__, 'name'),
        serial_number=pulumi.get(__ret__, 'serial_number'),
        signature=pulumi.get(__ret__, 'signature'),
        uploaded_on=pulumi.get(__ret__, 'uploaded_on'))
def get_mtls_certificate_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                mtls_certificate_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMtlsCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_mtls_certificate = cloudflare.get_mtls_certificate(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        mtls_certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str mtls_certificate_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['mtlsCertificateId'] = mtls_certificate_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMtlsCertificate:getMtlsCertificate', __args__, opts=opts, typ=GetMtlsCertificateResult)
    return __ret__.apply(lambda __response__: GetMtlsCertificateResult(
        account_id=pulumi.get(__response__, 'account_id'),
        ca=pulumi.get(__response__, 'ca'),
        certificates=pulumi.get(__response__, 'certificates'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        id=pulumi.get(__response__, 'id'),
        issuer=pulumi.get(__response__, 'issuer'),
        mtls_certificate_id=pulumi.get(__response__, 'mtls_certificate_id'),
        name=pulumi.get(__response__, 'name'),
        serial_number=pulumi.get(__response__, 'serial_number'),
        signature=pulumi.get(__response__, 'signature'),
        uploaded_on=pulumi.get(__response__, 'uploaded_on')))
