# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNotificationPolicyResult',
    'AwaitableGetNotificationPolicyResult',
    'get_notification_policy',
    'get_notification_policy_output',
]

@pulumi.output_type
class GetNotificationPolicyResult:
    """
    A collection of values returned by getNotificationPolicy.
    """
    def __init__(__self__, account_id=None, alert_interval=None, alert_type=None, created=None, description=None, enabled=None, filters=None, id=None, mechanisms=None, modified=None, name=None, policy_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if alert_interval and not isinstance(alert_interval, str):
            raise TypeError("Expected argument 'alert_interval' to be a str")
        pulumi.set(__self__, "alert_interval", alert_interval)
        if alert_type and not isinstance(alert_type, str):
            raise TypeError("Expected argument 'alert_type' to be a str")
        pulumi.set(__self__, "alert_type", alert_type)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if filters and not isinstance(filters, dict):
            raise TypeError("Expected argument 'filters' to be a dict")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mechanisms and not isinstance(mechanisms, dict):
            raise TypeError("Expected argument 'mechanisms' to be a dict")
        pulumi.set(__self__, "mechanisms", mechanisms)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        The account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="alertInterval")
    def alert_interval(self) -> builtins.str:
        """
        Optional specification of how often to re-alert from the same incident, not support on all alert types.
        """
        return pulumi.get(self, "alert_interval")

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> builtins.str:
        """
        Refers to which event will trigger a Notification dispatch. You can use the endpoint to get available alert types which then will give you a list of possible values.
        Available values: "access*custom*certificate*expiration*type", "advanced*ddos*attack*l4*alert", "advanced*ddos*attack*l7*alert", "advanced*http*alert*error", "bgp*hijack*notification", "billing*usage*alert", "block*notification*block*removed", "block*notification*new*block", "block*notification*review*rejected", "bot*traffic*basic*alert", "brand*protection*alert", "brand*protection*digest", "clickhouse*alert*fw*anomaly", "clickhouse*alert*fw*ent*anomaly", "cloudforce*one*request*notification", "custom*analytics", "custom*bot*detection*alert", "custom*ssl*certificate*event*type", "dedicated*ssl*certificate*event*type", "device*connectivity*anomaly*alert", "dos*attack*l4", "dos*attack*l7", "expiring*service*token*alert", "failing*logpush*job*disabled*alert", "fbm*auto*advertisement", "fbm*dosd*attack", "fbm*volumetric*attack", "health*check*status*notification", "hostname*aop*custom*certificate*expiration*type", "http*alert*edge*error", "http*alert*origin*error", "image*notification", "image*resizing*notification", "incident*alert", "load*balancing*health*alert", "load*balancing*pool*enablement*alert", "logo*match*alert", "magic*tunnel*health*check*event", "magic*wan*tunnel*health", "maintenance*event*notification", "mtls*certificate*store*certificate*expiration*type", "pages*event*alert", "radar*notification", "real*origin*monitoring", "scriptmonitor*alert*new*code*change*detections", "scriptmonitor*alert*new*hosts", "scriptmonitor*alert*new*malicious*hosts", "scriptmonitor*alert*new*malicious*scripts", "scriptmonitor*alert*new*malicious*url", "scriptmonitor*alert*new*max*length*resource*url", "scriptmonitor*alert*new*resources", "secondary*dns*all*primaries*failing", "secondary*dns*primaries*failing", "secondary*dns*warning", "secondary*dns*zone*successfully*updated", "secondary*dns*zone*validation*warning", "security*insights*alert", "sentinel*alert", "stream*live*notifications", "synthetic*test*latency*alert", "synthetic*test*low*availability*alert", "traffic*anomalies*alert", "tunnel*health*event", "tunnel*update*event", "universal*ssl*event*type", "web*analytics*metrics*update", "zone*aop*custom*certificate*expiration*type".
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Optional description for the Notification policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether or not the Notification policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filters(self) -> 'outputs.GetNotificationPolicyFiltersResult':
        """
        Optional filters that allow you to be alerted only on a subset of events for that alert type based on some criteria. This is only available for select alert types. See alert type documentation for more details.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier of a notification policy
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mechanisms(self) -> 'outputs.GetNotificationPolicyMechanismsResult':
        """
        List of IDs that will be used when dispatching a notification. IDs for email type will be the email address.
        """
        return pulumi.get(self, "mechanisms")

    @property
    @pulumi.getter
    def modified(self) -> builtins.str:
        return pulumi.get(self, "modified")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of a notification policy
        """
        return pulumi.get(self, "policy_id")


class AwaitableGetNotificationPolicyResult(GetNotificationPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationPolicyResult(
            account_id=self.account_id,
            alert_interval=self.alert_interval,
            alert_type=self.alert_type,
            created=self.created,
            description=self.description,
            enabled=self.enabled,
            filters=self.filters,
            id=self.id,
            mechanisms=self.mechanisms,
            modified=self.modified,
            name=self.name,
            policy_id=self.policy_id)


def get_notification_policy(account_id: Optional[builtins.str] = None,
                            policy_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationPolicyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_notification_policy = cloudflare.get_notification_policy(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        policy_id="0da2b59e-f118-439d-8097-bdfb215203c9")
    ```


    :param builtins.str account_id: The account id
    :param builtins.str policy_id: The unique identifier of a notification policy
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getNotificationPolicy:getNotificationPolicy', __args__, opts=opts, typ=GetNotificationPolicyResult).value

    return AwaitableGetNotificationPolicyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        alert_interval=pulumi.get(__ret__, 'alert_interval'),
        alert_type=pulumi.get(__ret__, 'alert_type'),
        created=pulumi.get(__ret__, 'created'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        mechanisms=pulumi.get(__ret__, 'mechanisms'),
        modified=pulumi.get(__ret__, 'modified'),
        name=pulumi.get(__ret__, 'name'),
        policy_id=pulumi.get(__ret__, 'policy_id'))
def get_notification_policy_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                   policy_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNotificationPolicyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_notification_policy = cloudflare.get_notification_policy(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        policy_id="0da2b59e-f118-439d-8097-bdfb215203c9")
    ```


    :param builtins.str account_id: The account id
    :param builtins.str policy_id: The unique identifier of a notification policy
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getNotificationPolicy:getNotificationPolicy', __args__, opts=opts, typ=GetNotificationPolicyResult)
    return __ret__.apply(lambda __response__: GetNotificationPolicyResult(
        account_id=pulumi.get(__response__, 'account_id'),
        alert_interval=pulumi.get(__response__, 'alert_interval'),
        alert_type=pulumi.get(__response__, 'alert_type'),
        created=pulumi.get(__response__, 'created'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        mechanisms=pulumi.get(__response__, 'mechanisms'),
        modified=pulumi.get(__response__, 'modified'),
        name=pulumi.get(__response__, 'name'),
        policy_id=pulumi.get(__response__, 'policy_id')))
