# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetObservatoryScheduledTestResult',
    'AwaitableGetObservatoryScheduledTestResult',
    'get_observatory_scheduled_test',
    'get_observatory_scheduled_test_output',
]

@pulumi.output_type
class GetObservatoryScheduledTestResult:
    """
    A collection of values returned by getObservatoryScheduledTest.
    """
    def __init__(__self__, frequency=None, id=None, region=None, url=None, zone_id=None):
        if frequency and not isinstance(frequency, str):
            raise TypeError("Expected argument 'frequency' to be a str")
        pulumi.set(__self__, "frequency", frequency)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def frequency(self) -> builtins.str:
        """
        The frequency of the test.
        Available values: "DAILY", "WEEKLY".
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        A test region.
        Available values: "asia-east1", "asia-northeast1", "asia-northeast2", "asia-south1", "asia-southeast1", "australia-southeast1", "europe-north1", "europe-southwest1", "europe-west1", "europe-west2", "europe-west3", "europe-west4", "europe-west8", "europe-west9", "me-west1", "southamerica-east1", "us-central1", "us-east1", "us-east4", "us-south1", "us-west1".
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        A URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetObservatoryScheduledTestResult(GetObservatoryScheduledTestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObservatoryScheduledTestResult(
            frequency=self.frequency,
            id=self.id,
            region=self.region,
            url=self.url,
            zone_id=self.zone_id)


def get_observatory_scheduled_test(region: Optional[builtins.str] = None,
                                   url: Optional[builtins.str] = None,
                                   zone_id: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObservatoryScheduledTestResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_observatory_scheduled_test = cloudflare.get_observatory_scheduled_test(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        url="example.com",
        region="us-central1")
    ```


    :param builtins.str region: A test region.
           Available values: "asia-east1", "asia-northeast1", "asia-northeast2", "asia-south1", "asia-southeast1", "australia-southeast1", "europe-north1", "europe-southwest1", "europe-west1", "europe-west2", "europe-west3", "europe-west4", "europe-west8", "europe-west9", "me-west1", "southamerica-east1", "us-central1", "us-east1", "us-east4", "us-south1", "us-west1".
    :param builtins.str url: A URL.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['url'] = url
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getObservatoryScheduledTest:getObservatoryScheduledTest', __args__, opts=opts, typ=GetObservatoryScheduledTestResult).value

    return AwaitableGetObservatoryScheduledTestResult(
        frequency=pulumi.get(__ret__, 'frequency'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        url=pulumi.get(__ret__, 'url'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_observatory_scheduled_test_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          url: Optional[pulumi.Input[builtins.str]] = None,
                                          zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObservatoryScheduledTestResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_observatory_scheduled_test = cloudflare.get_observatory_scheduled_test(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        url="example.com",
        region="us-central1")
    ```


    :param builtins.str region: A test region.
           Available values: "asia-east1", "asia-northeast1", "asia-northeast2", "asia-south1", "asia-southeast1", "australia-southeast1", "europe-north1", "europe-southwest1", "europe-west1", "europe-west2", "europe-west3", "europe-west4", "europe-west8", "europe-west9", "me-west1", "southamerica-east1", "us-central1", "us-east1", "us-east4", "us-south1", "us-west1".
    :param builtins.str url: A URL.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['url'] = url
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getObservatoryScheduledTest:getObservatoryScheduledTest', __args__, opts=opts, typ=GetObservatoryScheduledTestResult)
    return __ret__.apply(lambda __response__: GetObservatoryScheduledTestResult(
        frequency=pulumi.get(__response__, 'frequency'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        url=pulumi.get(__response__, 'url'),
        zone_id=pulumi.get(__response__, 'zone_id')))
