# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOriginCaCertificatesResult',
    'AwaitableGetOriginCaCertificatesResult',
    'get_origin_ca_certificates',
    'get_origin_ca_certificates_output',
]

@pulumi.output_type
class GetOriginCaCertificatesResult:
    """
    A collection of values returned by getOriginCaCertificates.
    """
    def __init__(__self__, id=None, limit=None, max_items=None, offset=None, results=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        Limit to the number of records returned.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def offset(self) -> Optional[builtins.int]:
        """
        Offset the results
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetOriginCaCertificatesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetOriginCaCertificatesResult(GetOriginCaCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOriginCaCertificatesResult(
            id=self.id,
            limit=self.limit,
            max_items=self.max_items,
            offset=self.offset,
            results=self.results,
            zone_id=self.zone_id)


def get_origin_ca_certificates(limit: Optional[builtins.int] = None,
                               max_items: Optional[builtins.int] = None,
                               offset: Optional[builtins.int] = None,
                               zone_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOriginCaCertificatesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_origin_ca_certificates = cloudflare.get_origin_ca_certificates(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        limit=10,
        offset=10)
    ```


    :param builtins.int limit: Limit to the number of records returned.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.int offset: Offset the results
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['maxItems'] = max_items
    __args__['offset'] = offset
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getOriginCaCertificates:getOriginCaCertificates', __args__, opts=opts, typ=GetOriginCaCertificatesResult).value

    return AwaitableGetOriginCaCertificatesResult(
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        max_items=pulumi.get(__ret__, 'max_items'),
        offset=pulumi.get(__ret__, 'offset'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_origin_ca_certificates_output(limit: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                      max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                      offset: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                      zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOriginCaCertificatesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_origin_ca_certificates = cloudflare.get_origin_ca_certificates(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        limit=10,
        offset=10)
    ```


    :param builtins.int limit: Limit to the number of records returned.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.int offset: Offset the results
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['maxItems'] = max_items
    __args__['offset'] = offset
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getOriginCaCertificates:getOriginCaCertificates', __args__, opts=opts, typ=GetOriginCaCertificatesResult)
    return __ret__.apply(lambda __response__: GetOriginCaCertificatesResult(
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        max_items=pulumi.get(__response__, 'max_items'),
        offset=pulumi.get(__response__, 'offset'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
