# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPageShieldScriptsListResult',
    'AwaitableGetPageShieldScriptsListResult',
    'get_page_shield_scripts_list',
    'get_page_shield_scripts_list_output',
]

@pulumi.output_type
class GetPageShieldScriptsListResult:
    """
    A collection of values returned by getPageShieldScriptsList.
    """
    def __init__(__self__, direction=None, exclude_cdn_cgi=None, exclude_duplicates=None, exclude_urls=None, export=None, hosts=None, id=None, max_items=None, order_by=None, page=None, page_url=None, per_page=None, prioritize_malicious=None, results=None, status=None, urls=None, zone_id=None):
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if exclude_cdn_cgi and not isinstance(exclude_cdn_cgi, bool):
            raise TypeError("Expected argument 'exclude_cdn_cgi' to be a bool")
        pulumi.set(__self__, "exclude_cdn_cgi", exclude_cdn_cgi)
        if exclude_duplicates and not isinstance(exclude_duplicates, bool):
            raise TypeError("Expected argument 'exclude_duplicates' to be a bool")
        pulumi.set(__self__, "exclude_duplicates", exclude_duplicates)
        if exclude_urls and not isinstance(exclude_urls, str):
            raise TypeError("Expected argument 'exclude_urls' to be a str")
        pulumi.set(__self__, "exclude_urls", exclude_urls)
        if export and not isinstance(export, str):
            raise TypeError("Expected argument 'export' to be a str")
        pulumi.set(__self__, "export", export)
        if hosts and not isinstance(hosts, str):
            raise TypeError("Expected argument 'hosts' to be a str")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, str):
            raise TypeError("Expected argument 'page' to be a str")
        pulumi.set(__self__, "page", page)
        if page_url and not isinstance(page_url, str):
            raise TypeError("Expected argument 'page_url' to be a str")
        pulumi.set(__self__, "page_url", page_url)
        if per_page and not isinstance(per_page, float):
            raise TypeError("Expected argument 'per_page' to be a float")
        pulumi.set(__self__, "per_page", per_page)
        if prioritize_malicious and not isinstance(prioritize_malicious, bool):
            raise TypeError("Expected argument 'prioritize_malicious' to be a bool")
        pulumi.set(__self__, "prioritize_malicious", prioritize_malicious)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if urls and not isinstance(urls, str):
            raise TypeError("Expected argument 'urls' to be a str")
        pulumi.set(__self__, "urls", urls)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def direction(self) -> Optional[builtins.str]:
        """
        The direction used to sort returned scripts.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="excludeCdnCgi")
    def exclude_cdn_cgi(self) -> builtins.bool:
        """
        When true, excludes scripts seen in a `/cdn-cgi` path from the returned scripts. The default value is true.
        """
        return pulumi.get(self, "exclude_cdn_cgi")

    @property
    @pulumi.getter(name="excludeDuplicates")
    def exclude_duplicates(self) -> builtins.bool:
        """
        When true, excludes duplicate scripts. We consider a script duplicate of another if their javascript
        content matches and they share the same url host and zone hostname. In such case, we return the most
        recent script for the URL host and zone hostname combination.
        """
        return pulumi.get(self, "exclude_duplicates")

    @property
    @pulumi.getter(name="excludeUrls")
    def exclude_urls(self) -> Optional[builtins.str]:
        """
        Excludes scripts whose URL contains one of the URL-encoded URLs separated by commas.
        """
        return pulumi.get(self, "exclude_urls")

    @property
    @pulumi.getter
    def export(self) -> Optional[builtins.str]:
        """
        Export the list of scripts as a file.
        Available values: "csv".
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[builtins.str]:
        """
        Includes scripts that match one or more URL-encoded hostnames separated by commas.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def page(self) -> Optional[builtins.str]:
        return pulumi.get(self, "page")

    @property
    @pulumi.getter(name="pageUrl")
    def page_url(self) -> Optional[builtins.str]:
        return pulumi.get(self, "page_url")

    @property
    @pulumi.getter(name="perPage")
    def per_page(self) -> Optional[builtins.float]:
        return pulumi.get(self, "per_page")

    @property
    @pulumi.getter(name="prioritizeMalicious")
    def prioritize_malicious(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "prioritize_malicious")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetPageShieldScriptsListResultResult']:
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def urls(self) -> Optional[builtins.str]:
        return pulumi.get(self, "urls")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetPageShieldScriptsListResult(GetPageShieldScriptsListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPageShieldScriptsListResult(
            direction=self.direction,
            exclude_cdn_cgi=self.exclude_cdn_cgi,
            exclude_duplicates=self.exclude_duplicates,
            exclude_urls=self.exclude_urls,
            export=self.export,
            hosts=self.hosts,
            id=self.id,
            max_items=self.max_items,
            order_by=self.order_by,
            page=self.page,
            page_url=self.page_url,
            per_page=self.per_page,
            prioritize_malicious=self.prioritize_malicious,
            results=self.results,
            status=self.status,
            urls=self.urls,
            zone_id=self.zone_id)


def get_page_shield_scripts_list(direction: Optional[builtins.str] = None,
                                 exclude_cdn_cgi: Optional[builtins.bool] = None,
                                 exclude_duplicates: Optional[builtins.bool] = None,
                                 exclude_urls: Optional[builtins.str] = None,
                                 export: Optional[builtins.str] = None,
                                 hosts: Optional[builtins.str] = None,
                                 max_items: Optional[builtins.int] = None,
                                 order_by: Optional[builtins.str] = None,
                                 page: Optional[builtins.str] = None,
                                 page_url: Optional[builtins.str] = None,
                                 per_page: Optional[builtins.float] = None,
                                 prioritize_malicious: Optional[builtins.bool] = None,
                                 status: Optional[builtins.str] = None,
                                 urls: Optional[builtins.str] = None,
                                 zone_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPageShieldScriptsListResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_shield_scripts_list = cloudflare.get_page_shield_scripts_list(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="asc",
        exclude_urls="blog.cloudflare.com,www.example",
        export="csv",
        hosts="blog.cloudflare.com,www.example*,*cloudflare.com",
        order_by="first_seen_at",
        page="2",
        page_url="example.com/page,*/checkout,example.com/*,*checkout*",
        per_page=100,
        prioritize_malicious=True,
        status="active,inactive",
        urls="blog.cloudflare.com,www.example")
    ```


    :param builtins.str direction: The direction used to sort returned scripts.
           Available values: "asc", "desc".
    :param builtins.bool exclude_cdn_cgi: When true, excludes scripts seen in a `/cdn-cgi` path from the returned scripts. The default value is true.
    :param builtins.bool exclude_duplicates: When true, excludes duplicate scripts. We consider a script duplicate of another if their javascript
           content matches and they share the same url host and zone hostname. In such case, we return the most
           recent script for the URL host and zone hostname combination.
    :param builtins.str exclude_urls: Excludes scripts whose URL contains one of the URL-encoded URLs separated by commas.
    :param builtins.str export: Export the list of scripts as a file.
           Available values: "csv".
    :param builtins.str hosts: Includes scripts that match one or more URL-encoded hostnames separated by commas.
    :param builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['excludeCdnCgi'] = exclude_cdn_cgi
    __args__['excludeDuplicates'] = exclude_duplicates
    __args__['excludeUrls'] = exclude_urls
    __args__['export'] = export
    __args__['hosts'] = hosts
    __args__['maxItems'] = max_items
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['pageUrl'] = page_url
    __args__['perPage'] = per_page
    __args__['prioritizeMalicious'] = prioritize_malicious
    __args__['status'] = status
    __args__['urls'] = urls
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getPageShieldScriptsList:getPageShieldScriptsList', __args__, opts=opts, typ=GetPageShieldScriptsListResult).value

    return AwaitableGetPageShieldScriptsListResult(
        direction=pulumi.get(__ret__, 'direction'),
        exclude_cdn_cgi=pulumi.get(__ret__, 'exclude_cdn_cgi'),
        exclude_duplicates=pulumi.get(__ret__, 'exclude_duplicates'),
        exclude_urls=pulumi.get(__ret__, 'exclude_urls'),
        export=pulumi.get(__ret__, 'export'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        page_url=pulumi.get(__ret__, 'page_url'),
        per_page=pulumi.get(__ret__, 'per_page'),
        prioritize_malicious=pulumi.get(__ret__, 'prioritize_malicious'),
        results=pulumi.get(__ret__, 'results'),
        status=pulumi.get(__ret__, 'status'),
        urls=pulumi.get(__ret__, 'urls'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_page_shield_scripts_list_output(direction: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        exclude_cdn_cgi: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                        exclude_duplicates: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                        exclude_urls: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        export: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        hosts: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                        order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        page: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        page_url: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        per_page: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                                        prioritize_malicious: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                        status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        urls: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPageShieldScriptsListResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_shield_scripts_list = cloudflare.get_page_shield_scripts_list(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="asc",
        exclude_urls="blog.cloudflare.com,www.example",
        export="csv",
        hosts="blog.cloudflare.com,www.example*,*cloudflare.com",
        order_by="first_seen_at",
        page="2",
        page_url="example.com/page,*/checkout,example.com/*,*checkout*",
        per_page=100,
        prioritize_malicious=True,
        status="active,inactive",
        urls="blog.cloudflare.com,www.example")
    ```


    :param builtins.str direction: The direction used to sort returned scripts.
           Available values: "asc", "desc".
    :param builtins.bool exclude_cdn_cgi: When true, excludes scripts seen in a `/cdn-cgi` path from the returned scripts. The default value is true.
    :param builtins.bool exclude_duplicates: When true, excludes duplicate scripts. We consider a script duplicate of another if their javascript
           content matches and they share the same url host and zone hostname. In such case, we return the most
           recent script for the URL host and zone hostname combination.
    :param builtins.str exclude_urls: Excludes scripts whose URL contains one of the URL-encoded URLs separated by commas.
    :param builtins.str export: Export the list of scripts as a file.
           Available values: "csv".
    :param builtins.str hosts: Includes scripts that match one or more URL-encoded hostnames separated by commas.
    :param builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['excludeCdnCgi'] = exclude_cdn_cgi
    __args__['excludeDuplicates'] = exclude_duplicates
    __args__['excludeUrls'] = exclude_urls
    __args__['export'] = export
    __args__['hosts'] = hosts
    __args__['maxItems'] = max_items
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['pageUrl'] = page_url
    __args__['perPage'] = per_page
    __args__['prioritizeMalicious'] = prioritize_malicious
    __args__['status'] = status
    __args__['urls'] = urls
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getPageShieldScriptsList:getPageShieldScriptsList', __args__, opts=opts, typ=GetPageShieldScriptsListResult)
    return __ret__.apply(lambda __response__: GetPageShieldScriptsListResult(
        direction=pulumi.get(__response__, 'direction'),
        exclude_cdn_cgi=pulumi.get(__response__, 'exclude_cdn_cgi'),
        exclude_duplicates=pulumi.get(__response__, 'exclude_duplicates'),
        exclude_urls=pulumi.get(__response__, 'exclude_urls'),
        export=pulumi.get(__response__, 'export'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        page_url=pulumi.get(__response__, 'page_url'),
        per_page=pulumi.get(__response__, 'per_page'),
        prioritize_malicious=pulumi.get(__response__, 'prioritize_malicious'),
        results=pulumi.get(__response__, 'results'),
        status=pulumi.get(__response__, 'status'),
        urls=pulumi.get(__response__, 'urls'),
        zone_id=pulumi.get(__response__, 'zone_id')))
