# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPagesProjectResult',
    'AwaitableGetPagesProjectResult',
    'get_pages_project',
    'get_pages_project_output',
]

@pulumi.output_type
class GetPagesProjectResult:
    """
    A collection of values returned by getPagesProject.
    """
    def __init__(__self__, account_id=None, build_config=None, canonical_deployment=None, created_on=None, deployment_configs=None, domains=None, id=None, latest_deployment=None, name=None, production_branch=None, project_name=None, source=None, subdomain=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if build_config and not isinstance(build_config, dict):
            raise TypeError("Expected argument 'build_config' to be a dict")
        pulumi.set(__self__, "build_config", build_config)
        if canonical_deployment and not isinstance(canonical_deployment, dict):
            raise TypeError("Expected argument 'canonical_deployment' to be a dict")
        pulumi.set(__self__, "canonical_deployment", canonical_deployment)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if deployment_configs and not isinstance(deployment_configs, dict):
            raise TypeError("Expected argument 'deployment_configs' to be a dict")
        pulumi.set(__self__, "deployment_configs", deployment_configs)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_deployment and not isinstance(latest_deployment, dict):
            raise TypeError("Expected argument 'latest_deployment' to be a dict")
        pulumi.set(__self__, "latest_deployment", latest_deployment)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if production_branch and not isinstance(production_branch, str):
            raise TypeError("Expected argument 'production_branch' to be a str")
        pulumi.set(__self__, "production_branch", production_branch)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if source and not isinstance(source, dict):
            raise TypeError("Expected argument 'source' to be a dict")
        pulumi.set(__self__, "source", source)
        if subdomain and not isinstance(subdomain, str):
            raise TypeError("Expected argument 'subdomain' to be a str")
        pulumi.set(__self__, "subdomain", subdomain)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> 'outputs.GetPagesProjectBuildConfigResult':
        """
        Configs for the project build process.
        """
        return pulumi.get(self, "build_config")

    @property
    @pulumi.getter(name="canonicalDeployment")
    def canonical_deployment(self) -> 'outputs.GetPagesProjectCanonicalDeploymentResult':
        """
        Most recent deployment to the repo.
        """
        return pulumi.get(self, "canonical_deployment")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        """
        When the project was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="deploymentConfigs")
    def deployment_configs(self) -> 'outputs.GetPagesProjectDeploymentConfigsResult':
        """
        Configs for deployments in a project.
        """
        return pulumi.get(self, "deployment_configs")

    @property
    @pulumi.getter
    def domains(self) -> Sequence[builtins.str]:
        """
        A list of associated custom domains for the project.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Id of the project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestDeployment")
    def latest_deployment(self) -> 'outputs.GetPagesProjectLatestDeploymentResult':
        """
        Most recent deployment to the repo.
        """
        return pulumi.get(self, "latest_deployment")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productionBranch")
    def production_branch(self) -> builtins.str:
        """
        Production branch of the project. Used to identify production deployments.
        """
        return pulumi.get(self, "production_branch")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> builtins.str:
        """
        Name of the project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.GetPagesProjectSourceResult':
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def subdomain(self) -> builtins.str:
        """
        The Cloudflare subdomain associated with the project.
        """
        return pulumi.get(self, "subdomain")


class AwaitableGetPagesProjectResult(GetPagesProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPagesProjectResult(
            account_id=self.account_id,
            build_config=self.build_config,
            canonical_deployment=self.canonical_deployment,
            created_on=self.created_on,
            deployment_configs=self.deployment_configs,
            domains=self.domains,
            id=self.id,
            latest_deployment=self.latest_deployment,
            name=self.name,
            production_branch=self.production_branch,
            project_name=self.project_name,
            source=self.source,
            subdomain=self.subdomain)


def get_pages_project(account_id: Optional[builtins.str] = None,
                      project_name: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPagesProjectResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_pages_project = cloudflare.get_pages_project(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        project_name="this-is-my-project-01")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str project_name: Name of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getPagesProject:getPagesProject', __args__, opts=opts, typ=GetPagesProjectResult).value

    return AwaitableGetPagesProjectResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        build_config=pulumi.get(__ret__, 'build_config'),
        canonical_deployment=pulumi.get(__ret__, 'canonical_deployment'),
        created_on=pulumi.get(__ret__, 'created_on'),
        deployment_configs=pulumi.get(__ret__, 'deployment_configs'),
        domains=pulumi.get(__ret__, 'domains'),
        id=pulumi.get(__ret__, 'id'),
        latest_deployment=pulumi.get(__ret__, 'latest_deployment'),
        name=pulumi.get(__ret__, 'name'),
        production_branch=pulumi.get(__ret__, 'production_branch'),
        project_name=pulumi.get(__ret__, 'project_name'),
        source=pulumi.get(__ret__, 'source'),
        subdomain=pulumi.get(__ret__, 'subdomain'))
def get_pages_project_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                             project_name: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPagesProjectResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_pages_project = cloudflare.get_pages_project(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        project_name="this-is-my-project-01")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str project_name: Name of the project.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getPagesProject:getPagesProject', __args__, opts=opts, typ=GetPagesProjectResult)
    return __ret__.apply(lambda __response__: GetPagesProjectResult(
        account_id=pulumi.get(__response__, 'account_id'),
        build_config=pulumi.get(__response__, 'build_config'),
        canonical_deployment=pulumi.get(__response__, 'canonical_deployment'),
        created_on=pulumi.get(__response__, 'created_on'),
        deployment_configs=pulumi.get(__response__, 'deployment_configs'),
        domains=pulumi.get(__response__, 'domains'),
        id=pulumi.get(__response__, 'id'),
        latest_deployment=pulumi.get(__response__, 'latest_deployment'),
        name=pulumi.get(__response__, 'name'),
        production_branch=pulumi.get(__response__, 'production_branch'),
        project_name=pulumi.get(__response__, 'project_name'),
        source=pulumi.get(__response__, 'source'),
        subdomain=pulumi.get(__response__, 'subdomain')))
