# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRateLimitResult',
    'AwaitableGetRateLimitResult',
    'get_rate_limit',
    'get_rate_limit_output',
]

@pulumi.output_type
class GetRateLimitResult:
    """
    A collection of values returned by getRateLimit.
    """
    def __init__(__self__, action=None, bypasses=None, description=None, disabled=None, id=None, match=None, period=None, rate_limit_id=None, threshold=None, zone_id=None):
        if action and not isinstance(action, dict):
            raise TypeError("Expected argument 'action' to be a dict")
        pulumi.set(__self__, "action", action)
        if bypasses and not isinstance(bypasses, list):
            raise TypeError("Expected argument 'bypasses' to be a list")
        pulumi.set(__self__, "bypasses", bypasses)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match and not isinstance(match, dict):
            raise TypeError("Expected argument 'match' to be a dict")
        pulumi.set(__self__, "match", match)
        if period and not isinstance(period, float):
            raise TypeError("Expected argument 'period' to be a float")
        pulumi.set(__self__, "period", period)
        if rate_limit_id and not isinstance(rate_limit_id, str):
            raise TypeError("Expected argument 'rate_limit_id' to be a str")
        pulumi.set(__self__, "rate_limit_id", rate_limit_id)
        if threshold and not isinstance(threshold, float):
            raise TypeError("Expected argument 'threshold' to be a float")
        pulumi.set(__self__, "threshold", threshold)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.GetRateLimitActionResult':
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def bypasses(self) -> Sequence['outputs.GetRateLimitBypassResult']:
        """
        Criteria specifying when the current rate limit should be bypassed. You can specify that the rate limit should not apply to one or more URLs.
        """
        return pulumi.get(self, "bypasses")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> builtins.bool:
        """
        When true, indicates that the rate limit is currently disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Defines the unique identifier of the rate limit.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.GetRateLimitMatchResult':
        """
        Determines which traffic the rate limit counts towards the threshold.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def period(self) -> builtins.float:
        """
        The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="rateLimitId")
    def rate_limit_id(self) -> Optional[builtins.str]:
        """
        Defines the unique identifier of the rate limit.
        """
        return pulumi.get(self, "rate_limit_id")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetRateLimitResult(GetRateLimitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRateLimitResult(
            action=self.action,
            bypasses=self.bypasses,
            description=self.description,
            disabled=self.disabled,
            id=self.id,
            match=self.match,
            period=self.period,
            rate_limit_id=self.rate_limit_id,
            threshold=self.threshold,
            zone_id=self.zone_id)


def get_rate_limit(rate_limit_id: Optional[builtins.str] = None,
                   zone_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRateLimitResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_rate_limit = cloudflare.get_rate_limit(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        rate_limit_id="372e67954025e0ba6aaa6d586b9e0b59")
    ```


    :param builtins.str rate_limit_id: Defines the unique identifier of the rate limit.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['rateLimitId'] = rate_limit_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getRateLimit:getRateLimit', __args__, opts=opts, typ=GetRateLimitResult).value

    return AwaitableGetRateLimitResult(
        action=pulumi.get(__ret__, 'action'),
        bypasses=pulumi.get(__ret__, 'bypasses'),
        description=pulumi.get(__ret__, 'description'),
        disabled=pulumi.get(__ret__, 'disabled'),
        id=pulumi.get(__ret__, 'id'),
        match=pulumi.get(__ret__, 'match'),
        period=pulumi.get(__ret__, 'period'),
        rate_limit_id=pulumi.get(__ret__, 'rate_limit_id'),
        threshold=pulumi.get(__ret__, 'threshold'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_rate_limit_output(rate_limit_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          zone_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRateLimitResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_rate_limit = cloudflare.get_rate_limit(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        rate_limit_id="372e67954025e0ba6aaa6d586b9e0b59")
    ```


    :param builtins.str rate_limit_id: Defines the unique identifier of the rate limit.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['rateLimitId'] = rate_limit_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getRateLimit:getRateLimit', __args__, opts=opts, typ=GetRateLimitResult)
    return __ret__.apply(lambda __response__: GetRateLimitResult(
        action=pulumi.get(__response__, 'action'),
        bypasses=pulumi.get(__response__, 'bypasses'),
        description=pulumi.get(__response__, 'description'),
        disabled=pulumi.get(__response__, 'disabled'),
        id=pulumi.get(__response__, 'id'),
        match=pulumi.get(__response__, 'match'),
        period=pulumi.get(__response__, 'period'),
        rate_limit_id=pulumi.get(__response__, 'rate_limit_id'),
        threshold=pulumi.get(__response__, 'threshold'),
        zone_id=pulumi.get(__response__, 'zone_id')))
