# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRegionalHostnameResult',
    'AwaitableGetRegionalHostnameResult',
    'get_regional_hostname',
    'get_regional_hostname_output',
]

@pulumi.output_type
class GetRegionalHostnameResult:
    """
    A collection of values returned by getRegionalHostname.
    """
    def __init__(__self__, created_on=None, hostname=None, id=None, region_key=None, routing=None, zone_id=None):
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region_key and not isinstance(region_key, str):
            raise TypeError("Expected argument 'region_key' to be a str")
        pulumi.set(__self__, "region_key", region_key)
        if routing and not isinstance(routing, str):
            raise TypeError("Expected argument 'routing' to be a str")
        pulumi.set(__self__, "routing", routing)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        """
        When the regional hostname was created
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        DNS hostname to be regionalized, must be a subdomain of the zone. Wildcards are supported for one level, e.g `*.example.com`
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        DNS hostname to be regionalized, must be a subdomain of the zone. Wildcards are supported for one level, e.g `*.example.com`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="regionKey")
    def region_key(self) -> builtins.str:
        """
        Identifying key for the region
        """
        return pulumi.get(self, "region_key")

    @property
    @pulumi.getter
    def routing(self) -> builtins.str:
        """
        Configure which routing method to use for the regional hostname
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetRegionalHostnameResult(GetRegionalHostnameResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalHostnameResult(
            created_on=self.created_on,
            hostname=self.hostname,
            id=self.id,
            region_key=self.region_key,
            routing=self.routing,
            zone_id=self.zone_id)


def get_regional_hostname(hostname: Optional[builtins.str] = None,
                          zone_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalHostnameResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_regional_hostname = cloudflare.get_regional_hostname(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        hostname="foo.example.com")
    ```


    :param builtins.str hostname: DNS hostname to be regionalized, must be a subdomain of the zone. Wildcards are supported for one level, e.g `*.example.com`
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['hostname'] = hostname
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getRegionalHostname:getRegionalHostname', __args__, opts=opts, typ=GetRegionalHostnameResult).value

    return AwaitableGetRegionalHostnameResult(
        created_on=pulumi.get(__ret__, 'created_on'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        region_key=pulumi.get(__ret__, 'region_key'),
        routing=pulumi.get(__ret__, 'routing'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_regional_hostname_output(hostname: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionalHostnameResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_regional_hostname = cloudflare.get_regional_hostname(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        hostname="foo.example.com")
    ```


    :param builtins.str hostname: DNS hostname to be regionalized, must be a subdomain of the zone. Wildcards are supported for one level, e.g `*.example.com`
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['hostname'] = hostname
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getRegionalHostname:getRegionalHostname', __args__, opts=opts, typ=GetRegionalHostnameResult)
    return __ret__.apply(lambda __response__: GetRegionalHostnameResult(
        created_on=pulumi.get(__response__, 'created_on'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        region_key=pulumi.get(__response__, 'region_key'),
        routing=pulumi.get(__response__, 'routing'),
        zone_id=pulumi.get(__response__, 'zone_id')))
