# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetResourceGroupResult',
    'AwaitableGetResourceGroupResult',
    'get_resource_group',
    'get_resource_group_output',
]

@pulumi.output_type
class GetResourceGroupResult:
    """
    A collection of values returned by getResourceGroup.
    """
    def __init__(__self__, account_id=None, id=None, meta=None, name=None, resource_group_id=None, scopes=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if meta and not isinstance(meta, dict):
            raise TypeError("Expected argument 'meta' to be a dict")
        pulumi.set(__self__, "meta", meta)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier of the resource group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def meta(self) -> 'outputs.GetResourceGroupMetaResult':
        """
        Attributes associated to the resource group.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the resource group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> builtins.str:
        """
        Resource Group identifier tag.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.GetResourceGroupScopeResult']:
        """
        The scope associated to the resource group
        """
        return pulumi.get(self, "scopes")


class AwaitableGetResourceGroupResult(GetResourceGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceGroupResult(
            account_id=self.account_id,
            id=self.id,
            meta=self.meta,
            name=self.name,
            resource_group_id=self.resource_group_id,
            scopes=self.scopes)


def get_resource_group(account_id: Optional[builtins.str] = None,
                       resource_group_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceGroupResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_resource_group = cloudflare.get_resource_group(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        resource_group_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str resource_group_id: Resource Group identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['resourceGroupId'] = resource_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getResourceGroup:getResourceGroup', __args__, opts=opts, typ=GetResourceGroupResult).value

    return AwaitableGetResourceGroupResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        meta=pulumi.get(__ret__, 'meta'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        scopes=pulumi.get(__ret__, 'scopes'))
def get_resource_group_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                              resource_group_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceGroupResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_resource_group = cloudflare.get_resource_group(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        resource_group_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str resource_group_id: Resource Group identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['resourceGroupId'] = resource_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getResourceGroup:getResourceGroup', __args__, opts=opts, typ=GetResourceGroupResult)
    return __ret__.apply(lambda __response__: GetResourceGroupResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        meta=pulumi.get(__response__, 'meta'),
        name=pulumi.get(__response__, 'name'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        scopes=pulumi.get(__response__, 'scopes')))
