# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetResourceGroupsResult',
    'AwaitableGetResourceGroupsResult',
    'get_resource_groups',
    'get_resource_groups_output',
]

@pulumi.output_type
class GetResourceGroupsResult:
    """
    A collection of values returned by getResourceGroups.
    """
    def __init__(__self__, account_id=None, id=None, max_items=None, name=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        ID of the resource group to be fetched.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the resource group to be fetched.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetResourceGroupsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetResourceGroupsResult(GetResourceGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceGroupsResult(
            account_id=self.account_id,
            id=self.id,
            max_items=self.max_items,
            name=self.name,
            results=self.results)


def get_resource_groups(account_id: Optional[builtins.str] = None,
                        id: Optional[builtins.str] = None,
                        max_items: Optional[builtins.int] = None,
                        name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceGroupsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_resource_groups = cloudflare.get_resource_groups(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="023e105f4ecef8ad9ca31a8372d0c353",
        name="NameOfTheResourceGroup")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str id: ID of the resource group to be fetched.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str name: Name of the resource group to be fetched.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getResourceGroups:getResourceGroups', __args__, opts=opts, typ=GetResourceGroupsResult).value

    return AwaitableGetResourceGroupsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'))
def get_resource_groups_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                               id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceGroupsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_resource_groups = cloudflare.get_resource_groups(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="023e105f4ecef8ad9ca31a8372d0c353",
        name="NameOfTheResourceGroup")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str id: ID of the resource group to be fetched.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str name: Name of the resource group to be fetched.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getResourceGroups:getResourceGroups', __args__, opts=opts, typ=GetResourceGroupsResult)
    return __ret__.apply(lambda __response__: GetResourceGroupsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results')))
