# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSpectrumApplicationResult',
    'AwaitableGetSpectrumApplicationResult',
    'get_spectrum_application',
    'get_spectrum_application_output',
]

@pulumi.output_type
class GetSpectrumApplicationResult:
    """
    A collection of values returned by getSpectrumApplication.
    """
    def __init__(__self__, app_id=None, argo_smart_routing=None, created_on=None, dns=None, edge_ips=None, id=None, ip_firewall=None, modified_on=None, origin_directs=None, origin_dns=None, origin_port=None, protocol=None, proxy_protocol=None, tls=None, traffic_type=None, zone_id=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if argo_smart_routing and not isinstance(argo_smart_routing, bool):
            raise TypeError("Expected argument 'argo_smart_routing' to be a bool")
        pulumi.set(__self__, "argo_smart_routing", argo_smart_routing)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if dns and not isinstance(dns, dict):
            raise TypeError("Expected argument 'dns' to be a dict")
        pulumi.set(__self__, "dns", dns)
        if edge_ips and not isinstance(edge_ips, dict):
            raise TypeError("Expected argument 'edge_ips' to be a dict")
        pulumi.set(__self__, "edge_ips", edge_ips)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_firewall and not isinstance(ip_firewall, bool):
            raise TypeError("Expected argument 'ip_firewall' to be a bool")
        pulumi.set(__self__, "ip_firewall", ip_firewall)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if origin_directs and not isinstance(origin_directs, list):
            raise TypeError("Expected argument 'origin_directs' to be a list")
        pulumi.set(__self__, "origin_directs", origin_directs)
        if origin_dns and not isinstance(origin_dns, dict):
            raise TypeError("Expected argument 'origin_dns' to be a dict")
        pulumi.set(__self__, "origin_dns", origin_dns)
        if origin_port and not isinstance(origin_port, dict):
            raise TypeError("Expected argument 'origin_port' to be a dict")
        pulumi.set(__self__, "origin_port", origin_port)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol and not isinstance(proxy_protocol, str):
            raise TypeError("Expected argument 'proxy_protocol' to be a str")
        pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if tls and not isinstance(tls, str):
            raise TypeError("Expected argument 'tls' to be a str")
        pulumi.set(__self__, "tls", tls)
        if traffic_type and not isinstance(traffic_type, str):
            raise TypeError("Expected argument 'traffic_type' to be a str")
        pulumi.set(__self__, "traffic_type", traffic_type)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> builtins.str:
        """
        App identifier.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="argoSmartRouting")
    def argo_smart_routing(self) -> builtins.bool:
        """
        Enables Argo Smart Routing for this application.
        Notes: Only available for TCP applications with traffic_type set to "direct".
        """
        return pulumi.get(self, "argo_smart_routing")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        """
        When the Application was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def dns(self) -> 'outputs.GetSpectrumApplicationDnsResult':
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="edgeIps")
    def edge_ips(self) -> 'outputs.GetSpectrumApplicationEdgeIpsResult':
        """
        The anycast edge IP configuration for the hostname of this application.
        """
        return pulumi.get(self, "edge_ips")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        App identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipFirewall")
    def ip_firewall(self) -> builtins.bool:
        """
        Enables IP Access Rules for this application.
        Notes: Only available for TCP applications.
        """
        return pulumi.get(self, "ip_firewall")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        When the Application was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="originDirects")
    def origin_directs(self) -> Sequence[builtins.str]:
        """
        List of origin IP addresses. Array may contain multiple IP addresses for load balancing.
        """
        return pulumi.get(self, "origin_directs")

    @property
    @pulumi.getter(name="originDns")
    def origin_dns(self) -> 'outputs.GetSpectrumApplicationOriginDnsResult':
        """
        The name and type of DNS record for the Spectrum application.
        """
        return pulumi.get(self, "origin_dns")

    @property
    @pulumi.getter(name="originPort")
    def origin_port(self) -> Any:
        """
        The destination port at the origin. Only specified in conjunction with origin_dns. May use an integer to specify a single origin port, for example `1000`, or a string to specify a range of origin ports, for example `"1000-2000"`.
        Notes: If specifying a port range, the number of ports in the range must match the number of ports specified in the "protocol" field.
        """
        return pulumi.get(self, "origin_port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The port configuration at Cloudflare's edge. May specify a single port, for example `"tcp/1000"`, or a range of ports, for example `"tcp/1000-2000"`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> builtins.str:
        """
        Enables Proxy Protocol to the origin. Refer to [Enable Proxy protocol](https://developers.cloudflare.com/spectrum/getting-started/proxy-protocol/) for implementation details on PROXY Protocol V1, PROXY Protocol V2, and Simple Proxy Protocol.
        Available values: "off", "v1", "v2", "simple".
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter
    def tls(self) -> builtins.str:
        """
        The type of TLS termination associated with the application.
        Available values: "off", "flexible", "full", "strict".
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> builtins.str:
        """
        Determines how data travels from the edge to your origin. When set to "direct", Spectrum will send traffic directly to your origin, and the application's type is derived from the `protocol`. When set to "http" or "https", Spectrum will apply Cloudflare's HTTP/HTTPS features as it sends traffic to your origin, and the application type matches this property exactly.
        Available values: "direct", "http", "https".
        """
        return pulumi.get(self, "traffic_type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Zone identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetSpectrumApplicationResult(GetSpectrumApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpectrumApplicationResult(
            app_id=self.app_id,
            argo_smart_routing=self.argo_smart_routing,
            created_on=self.created_on,
            dns=self.dns,
            edge_ips=self.edge_ips,
            id=self.id,
            ip_firewall=self.ip_firewall,
            modified_on=self.modified_on,
            origin_directs=self.origin_directs,
            origin_dns=self.origin_dns,
            origin_port=self.origin_port,
            protocol=self.protocol,
            proxy_protocol=self.proxy_protocol,
            tls=self.tls,
            traffic_type=self.traffic_type,
            zone_id=self.zone_id)


def get_spectrum_application(app_id: Optional[builtins.str] = None,
                             zone_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpectrumApplicationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_spectrum_application = cloudflare.get_spectrum_application(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        app_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str app_id: App identifier.
    :param builtins.str zone_id: Zone identifier.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getSpectrumApplication:getSpectrumApplication', __args__, opts=opts, typ=GetSpectrumApplicationResult).value

    return AwaitableGetSpectrumApplicationResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        argo_smart_routing=pulumi.get(__ret__, 'argo_smart_routing'),
        created_on=pulumi.get(__ret__, 'created_on'),
        dns=pulumi.get(__ret__, 'dns'),
        edge_ips=pulumi.get(__ret__, 'edge_ips'),
        id=pulumi.get(__ret__, 'id'),
        ip_firewall=pulumi.get(__ret__, 'ip_firewall'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        origin_directs=pulumi.get(__ret__, 'origin_directs'),
        origin_dns=pulumi.get(__ret__, 'origin_dns'),
        origin_port=pulumi.get(__ret__, 'origin_port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        proxy_protocol=pulumi.get(__ret__, 'proxy_protocol'),
        tls=pulumi.get(__ret__, 'tls'),
        traffic_type=pulumi.get(__ret__, 'traffic_type'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_spectrum_application_output(app_id: Optional[pulumi.Input[builtins.str]] = None,
                                    zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpectrumApplicationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_spectrum_application = cloudflare.get_spectrum_application(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        app_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str app_id: App identifier.
    :param builtins.str zone_id: Zone identifier.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getSpectrumApplication:getSpectrumApplication', __args__, opts=opts, typ=GetSpectrumApplicationResult)
    return __ret__.apply(lambda __response__: GetSpectrumApplicationResult(
        app_id=pulumi.get(__response__, 'app_id'),
        argo_smart_routing=pulumi.get(__response__, 'argo_smart_routing'),
        created_on=pulumi.get(__response__, 'created_on'),
        dns=pulumi.get(__response__, 'dns'),
        edge_ips=pulumi.get(__response__, 'edge_ips'),
        id=pulumi.get(__response__, 'id'),
        ip_firewall=pulumi.get(__response__, 'ip_firewall'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        origin_directs=pulumi.get(__response__, 'origin_directs'),
        origin_dns=pulumi.get(__response__, 'origin_dns'),
        origin_port=pulumi.get(__response__, 'origin_port'),
        protocol=pulumi.get(__response__, 'protocol'),
        proxy_protocol=pulumi.get(__response__, 'proxy_protocol'),
        tls=pulumi.get(__response__, 'tls'),
        traffic_type=pulumi.get(__response__, 'traffic_type'),
        zone_id=pulumi.get(__response__, 'zone_id')))
