# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSpectrumApplicationsResult',
    'AwaitableGetSpectrumApplicationsResult',
    'get_spectrum_applications',
    'get_spectrum_applications_output',
]

@pulumi.output_type
class GetSpectrumApplicationsResult:
    """
    A collection of values returned by getSpectrumApplications.
    """
    def __init__(__self__, direction=None, id=None, max_items=None, order=None, results=None, zone_id=None):
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def direction(self) -> builtins.str:
        """
        Sets the direction by which results are ordered.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def order(self) -> builtins.str:
        """
        Application field by which results are ordered.
        Available values: "protocol", "app*id", "created*on", "modified_on", "dns".
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetSpectrumApplicationsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Zone identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetSpectrumApplicationsResult(GetSpectrumApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpectrumApplicationsResult(
            direction=self.direction,
            id=self.id,
            max_items=self.max_items,
            order=self.order,
            results=self.results,
            zone_id=self.zone_id)


def get_spectrum_applications(direction: Optional[builtins.str] = None,
                              max_items: Optional[builtins.int] = None,
                              order: Optional[builtins.str] = None,
                              zone_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpectrumApplicationsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_spectrum_applications = cloudflare.get_spectrum_applications(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str direction: Sets the direction by which results are ordered.
           Available values: "asc", "desc".
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str order: Application field by which results are ordered.
           Available values: "protocol", "app*id", "created*on", "modified_on", "dns".
    :param builtins.str zone_id: Zone identifier.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['maxItems'] = max_items
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getSpectrumApplications:getSpectrumApplications', __args__, opts=opts, typ=GetSpectrumApplicationsResult).value

    return AwaitableGetSpectrumApplicationsResult(
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_spectrum_applications_output(direction: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                     order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpectrumApplicationsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_spectrum_applications = cloudflare.get_spectrum_applications(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str direction: Sets the direction by which results are ordered.
           Available values: "asc", "desc".
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str order: Application field by which results are ordered.
           Available values: "protocol", "app*id", "created*on", "modified_on", "dns".
    :param builtins.str zone_id: Zone identifier.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['maxItems'] = max_items
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getSpectrumApplications:getSpectrumApplications', __args__, opts=opts, typ=GetSpectrumApplicationsResult)
    return __ret__.apply(lambda __response__: GetSpectrumApplicationsResult(
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
