# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStreamKeyResult',
    'AwaitableGetStreamKeyResult',
    'get_stream_key',
    'get_stream_key_output',
]

@pulumi.output_type
class GetStreamKeyResult:
    """
    A collection of values returned by getStreamKey.
    """
    def __init__(__self__, account_id=None, created=None, id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        """
        The date and time a signing key was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")


class AwaitableGetStreamKeyResult(GetStreamKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamKeyResult(
            account_id=self.account_id,
            created=self.created,
            id=self.id)


def get_stream_key(account_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamKeyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream_key = cloudflare.get_stream_key(account_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getStreamKey:getStreamKey', __args__, opts=opts, typ=GetStreamKeyResult).value

    return AwaitableGetStreamKeyResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'))
def get_stream_key_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamKeyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream_key = cloudflare.get_stream_key(account_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getStreamKey:getStreamKey', __args__, opts=opts, typ=GetStreamKeyResult)
    return __ret__.apply(lambda __response__: GetStreamKeyResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id')))
