# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStreamLiveInputResult',
    'AwaitableGetStreamLiveInputResult',
    'get_stream_live_input',
    'get_stream_live_input_output',
]

@pulumi.output_type
class GetStreamLiveInputResult:
    """
    A collection of values returned by getStreamLiveInput.
    """
    def __init__(__self__, account_id=None, created=None, delete_recording_after_days=None, id=None, live_input_identifier=None, meta=None, modified=None, recording=None, rtmps=None, rtmps_playback=None, srt=None, srt_playback=None, status=None, uid=None, web_rtc=None, web_rtc_playback=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if delete_recording_after_days and not isinstance(delete_recording_after_days, float):
            raise TypeError("Expected argument 'delete_recording_after_days' to be a float")
        pulumi.set(__self__, "delete_recording_after_days", delete_recording_after_days)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if live_input_identifier and not isinstance(live_input_identifier, str):
            raise TypeError("Expected argument 'live_input_identifier' to be a str")
        pulumi.set(__self__, "live_input_identifier", live_input_identifier)
        if meta and not isinstance(meta, str):
            raise TypeError("Expected argument 'meta' to be a str")
        pulumi.set(__self__, "meta", meta)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if recording and not isinstance(recording, dict):
            raise TypeError("Expected argument 'recording' to be a dict")
        pulumi.set(__self__, "recording", recording)
        if rtmps and not isinstance(rtmps, dict):
            raise TypeError("Expected argument 'rtmps' to be a dict")
        pulumi.set(__self__, "rtmps", rtmps)
        if rtmps_playback and not isinstance(rtmps_playback, dict):
            raise TypeError("Expected argument 'rtmps_playback' to be a dict")
        pulumi.set(__self__, "rtmps_playback", rtmps_playback)
        if srt and not isinstance(srt, dict):
            raise TypeError("Expected argument 'srt' to be a dict")
        pulumi.set(__self__, "srt", srt)
        if srt_playback and not isinstance(srt_playback, dict):
            raise TypeError("Expected argument 'srt_playback' to be a dict")
        pulumi.set(__self__, "srt_playback", srt_playback)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if web_rtc and not isinstance(web_rtc, dict):
            raise TypeError("Expected argument 'web_rtc' to be a dict")
        pulumi.set(__self__, "web_rtc", web_rtc)
        if web_rtc_playback and not isinstance(web_rtc_playback, dict):
            raise TypeError("Expected argument 'web_rtc_playback' to be a dict")
        pulumi.set(__self__, "web_rtc_playback", web_rtc_playback)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        """
        The date and time the live input was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="deleteRecordingAfterDays")
    def delete_recording_after_days(self) -> builtins.float:
        """
        Indicates the number of days after which the live inputs recordings will be deleted. When a stream completes and the recording is ready, the value is used to calculate a scheduled deletion date for that recording. Omit the field to indicate no change, or include with a `null` value to remove an existing scheduled deletion.
        """
        return pulumi.get(self, "delete_recording_after_days")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="liveInputIdentifier")
    def live_input_identifier(self) -> builtins.str:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "live_input_identifier")

    @property
    @pulumi.getter
    def meta(self) -> builtins.str:
        """
        A user modifiable key-value store used to reference other systems of record for managing live inputs.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def modified(self) -> builtins.str:
        """
        The date and time the live input was last modified.
        """
        return pulumi.get(self, "modified")

    @property
    @pulumi.getter
    def recording(self) -> 'outputs.GetStreamLiveInputRecordingResult':
        """
        Records the input to a Cloudflare Stream video. Behavior depends on the mode. In most cases, the video will initially be viewable as a live video and transition to on-demand after a condition is satisfied.
        """
        return pulumi.get(self, "recording")

    @property
    @pulumi.getter
    def rtmps(self) -> 'outputs.GetStreamLiveInputRtmpsResult':
        """
        Details for streaming to an live input using RTMPS.
        """
        return pulumi.get(self, "rtmps")

    @property
    @pulumi.getter(name="rtmpsPlayback")
    def rtmps_playback(self) -> 'outputs.GetStreamLiveInputRtmpsPlaybackResult':
        """
        Details for playback from an live input using RTMPS.
        """
        return pulumi.get(self, "rtmps_playback")

    @property
    @pulumi.getter
    def srt(self) -> 'outputs.GetStreamLiveInputSrtResult':
        """
        Details for streaming to a live input using SRT.
        """
        return pulumi.get(self, "srt")

    @property
    @pulumi.getter(name="srtPlayback")
    def srt_playback(self) -> 'outputs.GetStreamLiveInputSrtPlaybackResult':
        """
        Details for playback from an live input using SRT.
        """
        return pulumi.get(self, "srt_playback")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The connection status of a live input.
        Available values: "connected", "reconnected", "reconnecting", "client*disconnect", "ttl*exceeded", "failed*to*connect", "failed*to*reconnect", "new*configuration*accepted".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        """
        A unique identifier for a live input.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="webRtc")
    def web_rtc(self) -> 'outputs.GetStreamLiveInputWebRtcResult':
        """
        Details for streaming to a live input using WebRTC.
        """
        return pulumi.get(self, "web_rtc")

    @property
    @pulumi.getter(name="webRtcPlayback")
    def web_rtc_playback(self) -> 'outputs.GetStreamLiveInputWebRtcPlaybackResult':
        """
        Details for playback from a live input using WebRTC.
        """
        return pulumi.get(self, "web_rtc_playback")


class AwaitableGetStreamLiveInputResult(GetStreamLiveInputResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamLiveInputResult(
            account_id=self.account_id,
            created=self.created,
            delete_recording_after_days=self.delete_recording_after_days,
            id=self.id,
            live_input_identifier=self.live_input_identifier,
            meta=self.meta,
            modified=self.modified,
            recording=self.recording,
            rtmps=self.rtmps,
            rtmps_playback=self.rtmps_playback,
            srt=self.srt,
            srt_playback=self.srt_playback,
            status=self.status,
            uid=self.uid,
            web_rtc=self.web_rtc,
            web_rtc_playback=self.web_rtc_playback)


def get_stream_live_input(account_id: Optional[builtins.str] = None,
                          live_input_identifier: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamLiveInputResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream_live_input = cloudflare.get_stream_live_input(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        live_input_identifier="66be4bf738797e01e1fca35a7bdecdcd")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str live_input_identifier: A unique identifier for a live input.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['liveInputIdentifier'] = live_input_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getStreamLiveInput:getStreamLiveInput', __args__, opts=opts, typ=GetStreamLiveInputResult).value

    return AwaitableGetStreamLiveInputResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created=pulumi.get(__ret__, 'created'),
        delete_recording_after_days=pulumi.get(__ret__, 'delete_recording_after_days'),
        id=pulumi.get(__ret__, 'id'),
        live_input_identifier=pulumi.get(__ret__, 'live_input_identifier'),
        meta=pulumi.get(__ret__, 'meta'),
        modified=pulumi.get(__ret__, 'modified'),
        recording=pulumi.get(__ret__, 'recording'),
        rtmps=pulumi.get(__ret__, 'rtmps'),
        rtmps_playback=pulumi.get(__ret__, 'rtmps_playback'),
        srt=pulumi.get(__ret__, 'srt'),
        srt_playback=pulumi.get(__ret__, 'srt_playback'),
        status=pulumi.get(__ret__, 'status'),
        uid=pulumi.get(__ret__, 'uid'),
        web_rtc=pulumi.get(__ret__, 'web_rtc'),
        web_rtc_playback=pulumi.get(__ret__, 'web_rtc_playback'))
def get_stream_live_input_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                 live_input_identifier: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamLiveInputResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_stream_live_input = cloudflare.get_stream_live_input(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        live_input_identifier="66be4bf738797e01e1fca35a7bdecdcd")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str live_input_identifier: A unique identifier for a live input.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['liveInputIdentifier'] = live_input_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getStreamLiveInput:getStreamLiveInput', __args__, opts=opts, typ=GetStreamLiveInputResult)
    return __ret__.apply(lambda __response__: GetStreamLiveInputResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created=pulumi.get(__response__, 'created'),
        delete_recording_after_days=pulumi.get(__response__, 'delete_recording_after_days'),
        id=pulumi.get(__response__, 'id'),
        live_input_identifier=pulumi.get(__response__, 'live_input_identifier'),
        meta=pulumi.get(__response__, 'meta'),
        modified=pulumi.get(__response__, 'modified'),
        recording=pulumi.get(__response__, 'recording'),
        rtmps=pulumi.get(__response__, 'rtmps'),
        rtmps_playback=pulumi.get(__response__, 'rtmps_playback'),
        srt=pulumi.get(__response__, 'srt'),
        srt_playback=pulumi.get(__response__, 'srt_playback'),
        status=pulumi.get(__response__, 'status'),
        uid=pulumi.get(__response__, 'uid'),
        web_rtc=pulumi.get(__response__, 'web_rtc'),
        web_rtc_playback=pulumi.get(__response__, 'web_rtc_playback')))
