# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTieredCacheResult',
    'AwaitableGetTieredCacheResult',
    'get_tiered_cache',
    'get_tiered_cache_output',
]

@pulumi.output_type
class GetTieredCacheResult:
    """
    A collection of values returned by getTieredCache.
    """
    def __init__(__self__, editable=None, id=None, modified_on=None, value=None, zone_id=None):
        if editable and not isinstance(editable, bool):
            raise TypeError("Expected argument 'editable' to be a bool")
        pulumi.set(__self__, "editable", editable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def editable(self) -> builtins.bool:
        """
        Whether the setting is editable
        """
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the zone setting.
        Available values: "tiered*cache*smart*topology*enable".
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        Last time this setting was modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the feature
        Available values: "on", "off".
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetTieredCacheResult(GetTieredCacheResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTieredCacheResult(
            editable=self.editable,
            id=self.id,
            modified_on=self.modified_on,
            value=self.value,
            zone_id=self.zone_id)


def get_tiered_cache(zone_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTieredCacheResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_tiered_cache = cloudflare.get_tiered_cache(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getTieredCache:getTieredCache', __args__, opts=opts, typ=GetTieredCacheResult).value

    return AwaitableGetTieredCacheResult(
        editable=pulumi.get(__ret__, 'editable'),
        id=pulumi.get(__ret__, 'id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        value=pulumi.get(__ret__, 'value'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_tiered_cache_output(zone_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTieredCacheResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_tiered_cache = cloudflare.get_tiered_cache(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getTieredCache:getTieredCache', __args__, opts=opts, typ=GetTieredCacheResult)
    return __ret__.apply(lambda __response__: GetTieredCacheResult(
        editable=pulumi.get(__response__, 'editable'),
        id=pulumi.get(__response__, 'id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        value=pulumi.get(__response__, 'value'),
        zone_id=pulumi.get(__response__, 'zone_id')))
