# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTotalTlsResult',
    'AwaitableGetTotalTlsResult',
    'get_total_tls',
    'get_total_tls_output',
]

@pulumi.output_type
class GetTotalTlsResult:
    """
    A collection of values returned by getTotalTls.
    """
    def __init__(__self__, certificate_authority=None, enabled=None, id=None, validity_period=None, zone_id=None):
        if certificate_authority and not isinstance(certificate_authority, str):
            raise TypeError("Expected argument 'certificate_authority' to be a str")
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if validity_period and not isinstance(validity_period, int):
            raise TypeError("Expected argument 'validity_period' to be a int")
        pulumi.set(__self__, "validity_period", validity_period)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> builtins.str:
        """
        The Certificate Authority that Total TLS certificates will be issued through.
        Available values: "google", "lets*encrypt", "ssl*com".
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        If enabled, Total TLS will order a hostname specific TLS certificate for any proxied A, AAAA, or CNAME record in your zone.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="validityPeriod")
    def validity_period(self) -> builtins.int:
        """
        The validity period in days for the certificates ordered via Total TLS.
        Available values: 90.
        """
        return pulumi.get(self, "validity_period")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetTotalTlsResult(GetTotalTlsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTotalTlsResult(
            certificate_authority=self.certificate_authority,
            enabled=self.enabled,
            id=self.id,
            validity_period=self.validity_period,
            zone_id=self.zone_id)


def get_total_tls(zone_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTotalTlsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_total_tls = cloudflare.get_total_tls(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getTotalTls:getTotalTls', __args__, opts=opts, typ=GetTotalTlsResult).value

    return AwaitableGetTotalTlsResult(
        certificate_authority=pulumi.get(__ret__, 'certificate_authority'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        validity_period=pulumi.get(__ret__, 'validity_period'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_total_tls_output(zone_id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTotalTlsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_total_tls = cloudflare.get_total_tls(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getTotalTls:getTotalTls', __args__, opts=opts, typ=GetTotalTlsResult)
    return __ret__.apply(lambda __response__: GetTotalTlsResult(
        certificate_authority=pulumi.get(__response__, 'certificate_authority'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        validity_period=pulumi.get(__response__, 'validity_period'),
        zone_id=pulumi.get(__response__, 'zone_id')))
