# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTurnstileWidgetResult',
    'AwaitableGetTurnstileWidgetResult',
    'get_turnstile_widget',
    'get_turnstile_widget_output',
]

@pulumi.output_type
class GetTurnstileWidgetResult:
    """
    A collection of values returned by getTurnstileWidget.
    """
    def __init__(__self__, account_id=None, bot_fight_mode=None, clearance_level=None, created_on=None, domains=None, ephemeral_id=None, filter=None, id=None, mode=None, modified_on=None, name=None, offlabel=None, region=None, secret=None, sitekey=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if bot_fight_mode and not isinstance(bot_fight_mode, bool):
            raise TypeError("Expected argument 'bot_fight_mode' to be a bool")
        pulumi.set(__self__, "bot_fight_mode", bot_fight_mode)
        if clearance_level and not isinstance(clearance_level, str):
            raise TypeError("Expected argument 'clearance_level' to be a str")
        pulumi.set(__self__, "clearance_level", clearance_level)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if ephemeral_id and not isinstance(ephemeral_id, bool):
            raise TypeError("Expected argument 'ephemeral_id' to be a bool")
        pulumi.set(__self__, "ephemeral_id", ephemeral_id)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if offlabel and not isinstance(offlabel, bool):
            raise TypeError("Expected argument 'offlabel' to be a bool")
        pulumi.set(__self__, "offlabel", offlabel)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)
        if sitekey and not isinstance(sitekey, str):
            raise TypeError("Expected argument 'sitekey' to be a str")
        pulumi.set(__self__, "sitekey", sitekey)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="botFightMode")
    def bot_fight_mode(self) -> builtins.bool:
        """
        If bot*fight*mode is set to `true`, Cloudflare issues computationally
        expensive challenges in response to malicious bots (ENT only).
        """
        return pulumi.get(self, "bot_fight_mode")

    @property
    @pulumi.getter(name="clearanceLevel")
    def clearance_level(self) -> builtins.str:
        """
        If Turnstile is embedded on a Cloudflare site and the widget should grant challenge clearance,
        this setting can determine the clearance level to be set
        Available values: "no_clearance", "jschallenge", "managed", "interactive".
        """
        return pulumi.get(self, "clearance_level")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        """
        When the widget was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def domains(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="ephemeralId")
    def ephemeral_id(self) -> builtins.bool:
        """
        Return the Ephemeral ID in /siteverify (ENT only).
        """
        return pulumi.get(self, "ephemeral_id")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetTurnstileWidgetFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Widget item identifier tag.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Widget Mode
        Available values: "non-interactive", "invisible", "managed".
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        When the widget was modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Human readable widget name. Not unique. Cloudflare suggests that you
        set this to a meaningful string to make it easier to identify your
        widget, and where it is used.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offlabel(self) -> builtins.bool:
        """
        Do not show any Cloudflare branding on the widget (ENT only).
        """
        return pulumi.get(self, "offlabel")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where this widget can be used. This cannot be changed after creation.
        Available values: "world", "china".
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        Secret key for this widget.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def sitekey(self) -> builtins.str:
        """
        Widget item identifier tag.
        """
        return pulumi.get(self, "sitekey")


class AwaitableGetTurnstileWidgetResult(GetTurnstileWidgetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTurnstileWidgetResult(
            account_id=self.account_id,
            bot_fight_mode=self.bot_fight_mode,
            clearance_level=self.clearance_level,
            created_on=self.created_on,
            domains=self.domains,
            ephemeral_id=self.ephemeral_id,
            filter=self.filter,
            id=self.id,
            mode=self.mode,
            modified_on=self.modified_on,
            name=self.name,
            offlabel=self.offlabel,
            region=self.region,
            secret=self.secret,
            sitekey=self.sitekey)


def get_turnstile_widget(account_id: Optional[builtins.str] = None,
                         filter: Optional[Union['GetTurnstileWidgetFilterArgs', 'GetTurnstileWidgetFilterArgsDict']] = None,
                         sitekey: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTurnstileWidgetResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_turnstile_widget = cloudflare.get_turnstile_widget(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        sitekey="0x4AAF00AAAABn0R22HWm-YUc")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str sitekey: Widget item identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['sitekey'] = sitekey
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getTurnstileWidget:getTurnstileWidget', __args__, opts=opts, typ=GetTurnstileWidgetResult).value

    return AwaitableGetTurnstileWidgetResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        bot_fight_mode=pulumi.get(__ret__, 'bot_fight_mode'),
        clearance_level=pulumi.get(__ret__, 'clearance_level'),
        created_on=pulumi.get(__ret__, 'created_on'),
        domains=pulumi.get(__ret__, 'domains'),
        ephemeral_id=pulumi.get(__ret__, 'ephemeral_id'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        mode=pulumi.get(__ret__, 'mode'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        offlabel=pulumi.get(__ret__, 'offlabel'),
        region=pulumi.get(__ret__, 'region'),
        secret=pulumi.get(__ret__, 'secret'),
        sitekey=pulumi.get(__ret__, 'sitekey'))
def get_turnstile_widget_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                filter: Optional[pulumi.Input[Optional[Union['GetTurnstileWidgetFilterArgs', 'GetTurnstileWidgetFilterArgsDict']]]] = None,
                                sitekey: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTurnstileWidgetResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_turnstile_widget = cloudflare.get_turnstile_widget(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        sitekey="0x4AAF00AAAABn0R22HWm-YUc")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str sitekey: Widget item identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['sitekey'] = sitekey
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getTurnstileWidget:getTurnstileWidget', __args__, opts=opts, typ=GetTurnstileWidgetResult)
    return __ret__.apply(lambda __response__: GetTurnstileWidgetResult(
        account_id=pulumi.get(__response__, 'account_id'),
        bot_fight_mode=pulumi.get(__response__, 'bot_fight_mode'),
        clearance_level=pulumi.get(__response__, 'clearance_level'),
        created_on=pulumi.get(__response__, 'created_on'),
        domains=pulumi.get(__response__, 'domains'),
        ephemeral_id=pulumi.get(__response__, 'ephemeral_id'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        mode=pulumi.get(__response__, 'mode'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        offlabel=pulumi.get(__response__, 'offlabel'),
        region=pulumi.get(__response__, 'region'),
        secret=pulumi.get(__response__, 'secret'),
        sitekey=pulumi.get(__response__, 'sitekey')))
