# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTurnstileWidgetsResult',
    'AwaitableGetTurnstileWidgetsResult',
    'get_turnstile_widgets',
    'get_turnstile_widgets_output',
]

@pulumi.output_type
class GetTurnstileWidgetsResult:
    """
    A collection of values returned by getTurnstileWidgets.
    """
    def __init__(__self__, account_id=None, direction=None, id=None, max_items=None, order=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def direction(self) -> Optional[builtins.str]:
        """
        Direction to order widgets.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        """
        Field to order widgets by.
        Available values: "id", "sitekey", "name", "created*on", "modified*on".
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetTurnstileWidgetsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetTurnstileWidgetsResult(GetTurnstileWidgetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTurnstileWidgetsResult(
            account_id=self.account_id,
            direction=self.direction,
            id=self.id,
            max_items=self.max_items,
            order=self.order,
            results=self.results)


def get_turnstile_widgets(account_id: Optional[builtins.str] = None,
                          direction: Optional[builtins.str] = None,
                          max_items: Optional[builtins.int] = None,
                          order: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTurnstileWidgetsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_turnstile_widgets = cloudflare.get_turnstile_widgets(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="asc",
        order="id")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str direction: Direction to order widgets.
           Available values: "asc", "desc".
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str order: Field to order widgets by.
           Available values: "id", "sitekey", "name", "created*on", "modified*on".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['direction'] = direction
    __args__['maxItems'] = max_items
    __args__['order'] = order
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getTurnstileWidgets:getTurnstileWidgets', __args__, opts=opts, typ=GetTurnstileWidgetsResult).value

    return AwaitableGetTurnstileWidgetsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'))
def get_turnstile_widgets_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                 direction: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                 order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTurnstileWidgetsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_turnstile_widgets = cloudflare.get_turnstile_widgets(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="asc",
        order="id")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str direction: Direction to order widgets.
           Available values: "asc", "desc".
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str order: Field to order widgets by.
           Available values: "id", "sitekey", "name", "created*on", "modified*on".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['direction'] = direction
    __args__['maxItems'] = max_items
    __args__['order'] = order
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getTurnstileWidgets:getTurnstileWidgets', __args__, opts=opts, typ=GetTurnstileWidgetsResult)
    return __ret__.apply(lambda __response__: GetTurnstileWidgetsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results')))
