# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetUserAgentBlockingRulesResult',
    'AwaitableGetUserAgentBlockingRulesResult',
    'get_user_agent_blocking_rules',
    'get_user_agent_blocking_rules_output',
]

@pulumi.output_type
class GetUserAgentBlockingRulesResult:
    """
    A collection of values returned by getUserAgentBlockingRules.
    """
    def __init__(__self__, description=None, description_search=None, id=None, max_items=None, results=None, ua_search=None, zone_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if description_search and not isinstance(description_search, str):
            raise TypeError("Expected argument 'description_search' to be a str")
        pulumi.set(__self__, "description_search", description_search)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if ua_search and not isinstance(ua_search, str):
            raise TypeError("Expected argument 'ua_search' to be a str")
        pulumi.set(__self__, "ua_search", ua_search)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A string to search for in the description of existing rules.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="descriptionSearch")
    def description_search(self) -> Optional[builtins.str]:
        """
        A string to search for in the description of existing rules.
        """
        return pulumi.get(self, "description_search")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetUserAgentBlockingRulesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="uaSearch")
    def ua_search(self) -> Optional[builtins.str]:
        """
        A string to search for in the user agent values of existing rules.
        """
        return pulumi.get(self, "ua_search")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetUserAgentBlockingRulesResult(GetUserAgentBlockingRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserAgentBlockingRulesResult(
            description=self.description,
            description_search=self.description_search,
            id=self.id,
            max_items=self.max_items,
            results=self.results,
            ua_search=self.ua_search,
            zone_id=self.zone_id)


def get_user_agent_blocking_rules(description: Optional[builtins.str] = None,
                                  description_search: Optional[builtins.str] = None,
                                  max_items: Optional[builtins.int] = None,
                                  ua_search: Optional[builtins.str] = None,
                                  zone_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserAgentBlockingRulesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_user_agent_blocking_rules = cloudflare.get_user_agent_blocking_rules(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        description="abusive",
        description_search="abusive",
        ua_search="Safari")
    ```


    :param builtins.str description: A string to search for in the description of existing rules.
    :param builtins.str description_search: A string to search for in the description of existing rules.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str ua_search: A string to search for in the user agent values of existing rules.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['descriptionSearch'] = description_search
    __args__['maxItems'] = max_items
    __args__['uaSearch'] = ua_search
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getUserAgentBlockingRules:getUserAgentBlockingRules', __args__, opts=opts, typ=GetUserAgentBlockingRulesResult).value

    return AwaitableGetUserAgentBlockingRulesResult(
        description=pulumi.get(__ret__, 'description'),
        description_search=pulumi.get(__ret__, 'description_search'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        ua_search=pulumi.get(__ret__, 'ua_search'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_user_agent_blocking_rules_output(description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         description_search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                         ua_search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserAgentBlockingRulesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_user_agent_blocking_rules = cloudflare.get_user_agent_blocking_rules(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        description="abusive",
        description_search="abusive",
        ua_search="Safari")
    ```


    :param builtins.str description: A string to search for in the description of existing rules.
    :param builtins.str description_search: A string to search for in the description of existing rules.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str ua_search: A string to search for in the user agent values of existing rules.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['descriptionSearch'] = description_search
    __args__['maxItems'] = max_items
    __args__['uaSearch'] = ua_search
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getUserAgentBlockingRules:getUserAgentBlockingRules', __args__, opts=opts, typ=GetUserAgentBlockingRulesResult)
    return __ret__.apply(lambda __response__: GetUserAgentBlockingRulesResult(
        description=pulumi.get(__response__, 'description'),
        description_search=pulumi.get(__response__, 'description_search'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        ua_search=pulumi.get(__response__, 'ua_search'),
        zone_id=pulumi.get(__response__, 'zone_id')))
