# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWeb3HostnameResult',
    'AwaitableGetWeb3HostnameResult',
    'get_web3_hostname',
    'get_web3_hostname_output',
]

@pulumi.output_type
class GetWeb3HostnameResult:
    """
    A collection of values returned by getWeb3Hostname.
    """
    def __init__(__self__, created_on=None, description=None, dnslink=None, id=None, identifier=None, modified_on=None, name=None, status=None, target=None, zone_id=None):
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dnslink and not isinstance(dnslink, str):
            raise TypeError("Expected argument 'dnslink' to be a str")
        pulumi.set(__self__, "dnslink", dnslink)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Specify an optional description of the hostname.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dnslink(self) -> builtins.str:
        """
        Specify the DNSLink value used if the target is ipfs.
        """
        return pulumi.get(self, "dnslink")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Specify the identifier of the hostname.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[builtins.str]:
        """
        Specify the identifier of the hostname.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Specify the hostname that points to the target gateway via CNAME.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Specifies the status of the hostname's activation.
        Available values: "active", "pending", "deleting", "error".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        """
        Specify the target gateway of the hostname.
        Available values: "ethereum", "ipfs", "ipfs*universal*path".
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Specify the identifier of the hostname.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetWeb3HostnameResult(GetWeb3HostnameResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWeb3HostnameResult(
            created_on=self.created_on,
            description=self.description,
            dnslink=self.dnslink,
            id=self.id,
            identifier=self.identifier,
            modified_on=self.modified_on,
            name=self.name,
            status=self.status,
            target=self.target,
            zone_id=self.zone_id)


def get_web3_hostname(identifier: Optional[builtins.str] = None,
                      zone_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWeb3HostnameResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_web3_hostname = cloudflare.get_web3_hostname(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        identifier="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str identifier: Specify the identifier of the hostname.
    :param builtins.str zone_id: Specify the identifier of the hostname.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWeb3Hostname:getWeb3Hostname', __args__, opts=opts, typ=GetWeb3HostnameResult).value

    return AwaitableGetWeb3HostnameResult(
        created_on=pulumi.get(__ret__, 'created_on'),
        description=pulumi.get(__ret__, 'description'),
        dnslink=pulumi.get(__ret__, 'dnslink'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        target=pulumi.get(__ret__, 'target'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_web3_hostname_output(identifier: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             zone_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWeb3HostnameResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_web3_hostname = cloudflare.get_web3_hostname(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        identifier="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str identifier: Specify the identifier of the hostname.
    :param builtins.str zone_id: Specify the identifier of the hostname.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWeb3Hostname:getWeb3Hostname', __args__, opts=opts, typ=GetWeb3HostnameResult)
    return __ret__.apply(lambda __response__: GetWeb3HostnameResult(
        created_on=pulumi.get(__response__, 'created_on'),
        description=pulumi.get(__response__, 'description'),
        dnslink=pulumi.get(__response__, 'dnslink'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        target=pulumi.get(__response__, 'target'),
        zone_id=pulumi.get(__response__, 'zone_id')))
