# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkersKvNamespaceResult',
    'AwaitableGetWorkersKvNamespaceResult',
    'get_workers_kv_namespace',
    'get_workers_kv_namespace_output',
]

@pulumi.output_type
class GetWorkersKvNamespaceResult:
    """
    A collection of values returned by getWorkersKvNamespace.
    """
    def __init__(__self__, account_id=None, beta=None, filter=None, id=None, namespace_id=None, supports_url_encoding=None, title=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if beta and not isinstance(beta, bool):
            raise TypeError("Expected argument 'beta' to be a bool")
        pulumi.set(__self__, "beta", beta)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if supports_url_encoding and not isinstance(supports_url_encoding, bool):
            raise TypeError("Expected argument 'supports_url_encoding' to be a bool")
        pulumi.set(__self__, "supports_url_encoding", supports_url_encoding)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def beta(self) -> builtins.bool:
        """
        True if new beta namespace, with additional preview features.
        """
        return pulumi.get(self, "beta")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetWorkersKvNamespaceFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Namespace identifier tag.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[builtins.str]:
        """
        Namespace identifier tag.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="supportsUrlEncoding")
    def supports_url_encoding(self) -> builtins.bool:
        """
        True if keys written on the URL will be URL-decoded before storing. For example, if set to "true", a key written on the URL as "%3F" will be stored as "?".
        """
        return pulumi.get(self, "supports_url_encoding")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A human-readable string name for a Namespace.
        """
        return pulumi.get(self, "title")


class AwaitableGetWorkersKvNamespaceResult(GetWorkersKvNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkersKvNamespaceResult(
            account_id=self.account_id,
            beta=self.beta,
            filter=self.filter,
            id=self.id,
            namespace_id=self.namespace_id,
            supports_url_encoding=self.supports_url_encoding,
            title=self.title)


def get_workers_kv_namespace(account_id: Optional[builtins.str] = None,
                             filter: Optional[Union['GetWorkersKvNamespaceFilterArgs', 'GetWorkersKvNamespaceFilterArgsDict']] = None,
                             namespace_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkersKvNamespaceResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_kv_namespace = cloudflare.get_workers_kv_namespace(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        namespace_id="0f2ac74b498b48028cb68387c421e279")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str namespace_id: Namespace identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['namespaceId'] = namespace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorkersKvNamespace:getWorkersKvNamespace', __args__, opts=opts, typ=GetWorkersKvNamespaceResult).value

    return AwaitableGetWorkersKvNamespaceResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        beta=pulumi.get(__ret__, 'beta'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        supports_url_encoding=pulumi.get(__ret__, 'supports_url_encoding'),
        title=pulumi.get(__ret__, 'title'))
def get_workers_kv_namespace_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                    filter: Optional[pulumi.Input[Optional[Union['GetWorkersKvNamespaceFilterArgs', 'GetWorkersKvNamespaceFilterArgsDict']]]] = None,
                                    namespace_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkersKvNamespaceResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_kv_namespace = cloudflare.get_workers_kv_namespace(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        namespace_id="0f2ac74b498b48028cb68387c421e279")
    ```


    :param builtins.str account_id: Identifier
    :param builtins.str namespace_id: Namespace identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['namespaceId'] = namespace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorkersKvNamespace:getWorkersKvNamespace', __args__, opts=opts, typ=GetWorkersKvNamespaceResult)
    return __ret__.apply(lambda __response__: GetWorkersKvNamespaceResult(
        account_id=pulumi.get(__response__, 'account_id'),
        beta=pulumi.get(__response__, 'beta'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        supports_url_encoding=pulumi.get(__response__, 'supports_url_encoding'),
        title=pulumi.get(__response__, 'title')))
