# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWorkersRouteResult',
    'AwaitableGetWorkersRouteResult',
    'get_workers_route',
    'get_workers_route_output',
]

@pulumi.output_type
class GetWorkersRouteResult:
    """
    A collection of values returned by getWorkersRoute.
    """
    def __init__(__self__, id=None, pattern=None, route_id=None, script=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if route_id and not isinstance(route_id, str):
            raise TypeError("Expected argument 'route_id' to be a str")
        pulumi.set(__self__, "route_id", route_id)
        if script and not isinstance(script, str):
            raise TypeError("Expected argument 'script' to be a str")
        pulumi.set(__self__, "script", script)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def pattern(self) -> builtins.str:
        """
        Pattern to match incoming requests against. [Learn more](https://developers.cloudflare.com/workers/configuration/routing/routes/#matching-behavior).
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter
    def script(self) -> builtins.str:
        """
        Name of the script to run if the route matches.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetWorkersRouteResult(GetWorkersRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkersRouteResult(
            id=self.id,
            pattern=self.pattern,
            route_id=self.route_id,
            script=self.script,
            zone_id=self.zone_id)


def get_workers_route(route_id: Optional[builtins.str] = None,
                      zone_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkersRouteResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_route = cloudflare.get_workers_route(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        route_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str route_id: Identifier.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['routeId'] = route_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorkersRoute:getWorkersRoute', __args__, opts=opts, typ=GetWorkersRouteResult).value

    return AwaitableGetWorkersRouteResult(
        id=pulumi.get(__ret__, 'id'),
        pattern=pulumi.get(__ret__, 'pattern'),
        route_id=pulumi.get(__ret__, 'route_id'),
        script=pulumi.get(__ret__, 'script'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_workers_route_output(route_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             zone_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkersRouteResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_route = cloudflare.get_workers_route(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        route_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str route_id: Identifier.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['routeId'] = route_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorkersRoute:getWorkersRoute', __args__, opts=opts, typ=GetWorkersRouteResult)
    return __ret__.apply(lambda __response__: GetWorkersRouteResult(
        id=pulumi.get(__response__, 'id'),
        pattern=pulumi.get(__response__, 'pattern'),
        route_id=pulumi.get(__response__, 'route_id'),
        script=pulumi.get(__response__, 'script'),
        zone_id=pulumi.get(__response__, 'zone_id')))
