# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWorkersScriptResult',
    'AwaitableGetWorkersScriptResult',
    'get_workers_script',
    'get_workers_script_output',
]

@pulumi.output_type
class GetWorkersScriptResult:
    """
    A collection of values returned by getWorkersScript.
    """
    def __init__(__self__, account_id=None, id=None, script_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if script_name and not isinstance(script_name, str):
            raise TypeError("Expected argument 'script_name' to be a str")
        pulumi.set(__self__, "script_name", script_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> builtins.str:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")


class AwaitableGetWorkersScriptResult(GetWorkersScriptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkersScriptResult(
            account_id=self.account_id,
            id=self.id,
            script_name=self.script_name)


def get_workers_script(account_id: Optional[builtins.str] = None,
                       script_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkersScriptResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_script = cloudflare.get_workers_script(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        script_name="this-is_my_script-01")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str script_name: Name of the script, used in URLs and route configuration.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['scriptName'] = script_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorkersScript:getWorkersScript', __args__, opts=opts, typ=GetWorkersScriptResult).value

    return AwaitableGetWorkersScriptResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        script_name=pulumi.get(__ret__, 'script_name'))
def get_workers_script_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                              script_name: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkersScriptResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_script = cloudflare.get_workers_script(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        script_name="this-is_my_script-01")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str script_name: Name of the script, used in URLs and route configuration.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['scriptName'] = script_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorkersScript:getWorkersScript', __args__, opts=opts, typ=GetWorkersScriptResult)
    return __ret__.apply(lambda __response__: GetWorkersScriptResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        script_name=pulumi.get(__response__, 'script_name')))
