# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustAccessApplicationsResult',
    'AwaitableGetZeroTrustAccessApplicationsResult',
    'get_zero_trust_access_applications',
    'get_zero_trust_access_applications_output',
]

@pulumi.output_type
class GetZeroTrustAccessApplicationsResult:
    """
    A collection of values returned by getZeroTrustAccessApplications.
    """
    def __init__(__self__, account_id=None, aud=None, domain=None, id=None, max_items=None, name=None, results=None, search=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if aud and not isinstance(aud, str):
            raise TypeError("Expected argument 'aud' to be a str")
        pulumi.set(__self__, "aud", aud)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def aud(self) -> Optional[builtins.str]:
        """
        The aud of the app.
        """
        return pulumi.get(self, "aud")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The domain of the app.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZeroTrustAccessApplicationsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def search(self) -> Optional[builtins.str]:
        """
        Search for apps by other listed query parameters.
        """
        return pulumi.get(self, "search")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessApplicationsResult(GetZeroTrustAccessApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessApplicationsResult(
            account_id=self.account_id,
            aud=self.aud,
            domain=self.domain,
            id=self.id,
            max_items=self.max_items,
            name=self.name,
            results=self.results,
            search=self.search,
            zone_id=self.zone_id)


def get_zero_trust_access_applications(account_id: Optional[builtins.str] = None,
                                       aud: Optional[builtins.str] = None,
                                       domain: Optional[builtins.str] = None,
                                       max_items: Optional[builtins.int] = None,
                                       name: Optional[builtins.str] = None,
                                       search: Optional[builtins.str] = None,
                                       zone_id: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessApplicationsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_applications = cloudflare.get_zero_trust_access_applications(account_id="account_id",
        zone_id="zone_id",
        aud="aud",
        domain="domain",
        name="name",
        search="search")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str aud: The aud of the app.
    :param builtins.str domain: The domain of the app.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str name: The name of the app.
    :param builtins.str search: Search for apps by other listed query parameters.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['aud'] = aud
    __args__['domain'] = domain
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['search'] = search
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessApplications:getZeroTrustAccessApplications', __args__, opts=opts, typ=GetZeroTrustAccessApplicationsResult).value

    return AwaitableGetZeroTrustAccessApplicationsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        aud=pulumi.get(__ret__, 'aud'),
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'),
        search=pulumi.get(__ret__, 'search'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_applications_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              aud: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              domain: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessApplicationsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_applications = cloudflare.get_zero_trust_access_applications(account_id="account_id",
        zone_id="zone_id",
        aud="aud",
        domain="domain",
        name="name",
        search="search")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str aud: The aud of the app.
    :param builtins.str domain: The domain of the app.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str name: The name of the app.
    :param builtins.str search: Search for apps by other listed query parameters.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['aud'] = aud
    __args__['domain'] = domain
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['search'] = search
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessApplications:getZeroTrustAccessApplications', __args__, opts=opts, typ=GetZeroTrustAccessApplicationsResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessApplicationsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        aud=pulumi.get(__response__, 'aud'),
        domain=pulumi.get(__response__, 'domain'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results'),
        search=pulumi.get(__response__, 'search'),
        zone_id=pulumi.get(__response__, 'zone_id')))
