# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustAccessMtlsCertificateResult',
    'AwaitableGetZeroTrustAccessMtlsCertificateResult',
    'get_zero_trust_access_mtls_certificate',
    'get_zero_trust_access_mtls_certificate_output',
]

@pulumi.output_type
class GetZeroTrustAccessMtlsCertificateResult:
    """
    A collection of values returned by getZeroTrustAccessMtlsCertificate.
    """
    def __init__(__self__, account_id=None, associated_hostnames=None, certificate_id=None, created_at=None, expires_on=None, fingerprint=None, id=None, name=None, updated_at=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if associated_hostnames and not isinstance(associated_hostnames, list):
            raise TypeError("Expected argument 'associated_hostnames' to be a list")
        pulumi.set(__self__, "associated_hostnames", associated_hostnames)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="associatedHostnames")
    def associated_hostnames(self) -> Sequence[builtins.str]:
        """
        The hostnames of the applications that will use this certificate.
        """
        return pulumi.get(self, "associated_hostnames")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> builtins.str:
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def fingerprint(self) -> builtins.str:
        """
        The MD5 fingerprint of the certificate.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the certificate.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessMtlsCertificateResult(GetZeroTrustAccessMtlsCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessMtlsCertificateResult(
            account_id=self.account_id,
            associated_hostnames=self.associated_hostnames,
            certificate_id=self.certificate_id,
            created_at=self.created_at,
            expires_on=self.expires_on,
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            updated_at=self.updated_at,
            zone_id=self.zone_id)


def get_zero_trust_access_mtls_certificate(account_id: Optional[builtins.str] = None,
                                           certificate_id: Optional[builtins.str] = None,
                                           zone_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessMtlsCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_mtls_certificate = cloudflare.get_zero_trust_access_mtls_certificate(certificate_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str certificate_id: UUID.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['certificateId'] = certificate_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessMtlsCertificate:getZeroTrustAccessMtlsCertificate', __args__, opts=opts, typ=GetZeroTrustAccessMtlsCertificateResult).value

    return AwaitableGetZeroTrustAccessMtlsCertificateResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        associated_hostnames=pulumi.get(__ret__, 'associated_hostnames'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_mtls_certificate_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                  certificate_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                  zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessMtlsCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_mtls_certificate = cloudflare.get_zero_trust_access_mtls_certificate(certificate_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str certificate_id: UUID.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['certificateId'] = certificate_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessMtlsCertificate:getZeroTrustAccessMtlsCertificate', __args__, opts=opts, typ=GetZeroTrustAccessMtlsCertificateResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessMtlsCertificateResult(
        account_id=pulumi.get(__response__, 'account_id'),
        associated_hostnames=pulumi.get(__response__, 'associated_hostnames'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        zone_id=pulumi.get(__response__, 'zone_id')))
