# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustAccessMtlsHostnameSettingsResult',
    'AwaitableGetZeroTrustAccessMtlsHostnameSettingsResult',
    'get_zero_trust_access_mtls_hostname_settings',
    'get_zero_trust_access_mtls_hostname_settings_output',
]

@pulumi.output_type
class GetZeroTrustAccessMtlsHostnameSettingsResult:
    """
    A collection of values returned by getZeroTrustAccessMtlsHostnameSettings.
    """
    def __init__(__self__, account_id=None, china_network=None, client_certificate_forwarding=None, hostname=None, id=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if china_network and not isinstance(china_network, bool):
            raise TypeError("Expected argument 'china_network' to be a bool")
        pulumi.set(__self__, "china_network", china_network)
        if client_certificate_forwarding and not isinstance(client_certificate_forwarding, bool):
            raise TypeError("Expected argument 'client_certificate_forwarding' to be a bool")
        pulumi.set(__self__, "client_certificate_forwarding", client_certificate_forwarding)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="chinaNetwork")
    def china_network(self) -> builtins.bool:
        """
        Request client certificates for this hostname in China. Can only be set to true if this zone is china network enabled.
        """
        return pulumi.get(self, "china_network")

    @property
    @pulumi.getter(name="clientCertificateForwarding")
    def client_certificate_forwarding(self) -> builtins.bool:
        """
        Client Certificate Forwarding is a feature that takes the client cert provided by the eyeball to the edge, and forwards it to the origin as a HTTP header to allow logging on the origin.
        """
        return pulumi.get(self, "client_certificate_forwarding")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname that these settings apply to.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessMtlsHostnameSettingsResult(GetZeroTrustAccessMtlsHostnameSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessMtlsHostnameSettingsResult(
            account_id=self.account_id,
            china_network=self.china_network,
            client_certificate_forwarding=self.client_certificate_forwarding,
            hostname=self.hostname,
            id=self.id,
            zone_id=self.zone_id)


def get_zero_trust_access_mtls_hostname_settings(account_id: Optional[builtins.str] = None,
                                                 zone_id: Optional[builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessMtlsHostnameSettingsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_mtls_hostname_settings = cloudflare.get_zero_trust_access_mtls_hostname_settings(account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessMtlsHostnameSettings:getZeroTrustAccessMtlsHostnameSettings', __args__, opts=opts, typ=GetZeroTrustAccessMtlsHostnameSettingsResult).value

    return AwaitableGetZeroTrustAccessMtlsHostnameSettingsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        china_network=pulumi.get(__ret__, 'china_network'),
        client_certificate_forwarding=pulumi.get(__ret__, 'client_certificate_forwarding'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_mtls_hostname_settings_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessMtlsHostnameSettingsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_mtls_hostname_settings = cloudflare.get_zero_trust_access_mtls_hostname_settings(account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessMtlsHostnameSettings:getZeroTrustAccessMtlsHostnameSettings', __args__, opts=opts, typ=GetZeroTrustAccessMtlsHostnameSettingsResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessMtlsHostnameSettingsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        china_network=pulumi.get(__response__, 'china_network'),
        client_certificate_forwarding=pulumi.get(__response__, 'client_certificate_forwarding'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
