# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustAccessShortLivedCertificateResult',
    'AwaitableGetZeroTrustAccessShortLivedCertificateResult',
    'get_zero_trust_access_short_lived_certificate',
    'get_zero_trust_access_short_lived_certificate_output',
]

@pulumi.output_type
class GetZeroTrustAccessShortLivedCertificateResult:
    """
    A collection of values returned by getZeroTrustAccessShortLivedCertificate.
    """
    def __init__(__self__, account_id=None, app_id=None, aud=None, id=None, public_key=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if aud and not isinstance(aud, str):
            raise TypeError("Expected argument 'aud' to be a str")
        pulumi.set(__self__, "aud", aud)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def aud(self) -> builtins.str:
        """
        The Application Audience (AUD) tag. Identifies the application associated with the CA.
        """
        return pulumi.get(self, "aud")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the CA.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        The public key to add to your SSH server configuration.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessShortLivedCertificateResult(GetZeroTrustAccessShortLivedCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessShortLivedCertificateResult(
            account_id=self.account_id,
            app_id=self.app_id,
            aud=self.aud,
            id=self.id,
            public_key=self.public_key,
            zone_id=self.zone_id)


def get_zero_trust_access_short_lived_certificate(account_id: Optional[builtins.str] = None,
                                                  app_id: Optional[builtins.str] = None,
                                                  zone_id: Optional[builtins.str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessShortLivedCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_short_lived_certificate = cloudflare.get_zero_trust_access_short_lived_certificate(app_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str app_id: UUID.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['appId'] = app_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessShortLivedCertificate:getZeroTrustAccessShortLivedCertificate', __args__, opts=opts, typ=GetZeroTrustAccessShortLivedCertificateResult).value

    return AwaitableGetZeroTrustAccessShortLivedCertificateResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        app_id=pulumi.get(__ret__, 'app_id'),
        aud=pulumi.get(__ret__, 'aud'),
        id=pulumi.get(__ret__, 'id'),
        public_key=pulumi.get(__ret__, 'public_key'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_short_lived_certificate_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         app_id: Optional[pulumi.Input[builtins.str]] = None,
                                                         zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessShortLivedCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_short_lived_certificate = cloudflare.get_zero_trust_access_short_lived_certificate(app_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str app_id: UUID.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['appId'] = app_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessShortLivedCertificate:getZeroTrustAccessShortLivedCertificate', __args__, opts=opts, typ=GetZeroTrustAccessShortLivedCertificateResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessShortLivedCertificateResult(
        account_id=pulumi.get(__response__, 'account_id'),
        app_id=pulumi.get(__response__, 'app_id'),
        aud=pulumi.get(__response__, 'aud'),
        id=pulumi.get(__response__, 'id'),
        public_key=pulumi.get(__response__, 'public_key'),
        zone_id=pulumi.get(__response__, 'zone_id')))
