# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustDeviceManagedNetworksResult',
    'AwaitableGetZeroTrustDeviceManagedNetworksResult',
    'get_zero_trust_device_managed_networks',
    'get_zero_trust_device_managed_networks_output',
]

@pulumi.output_type
class GetZeroTrustDeviceManagedNetworksResult:
    """
    A collection of values returned by getZeroTrustDeviceManagedNetworks.
    """
    def __init__(__self__, account_id=None, config=None, id=None, name=None, network_id=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.GetZeroTrustDeviceManagedNetworksConfigResult':
        """
        The configuration object containing information for the WARP client to detect the managed network.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        API UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the device managed network. This name must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        API UUID.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of device managed network.
        Available values: "tls".
        """
        return pulumi.get(self, "type")


class AwaitableGetZeroTrustDeviceManagedNetworksResult(GetZeroTrustDeviceManagedNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustDeviceManagedNetworksResult(
            account_id=self.account_id,
            config=self.config,
            id=self.id,
            name=self.name,
            network_id=self.network_id,
            type=self.type)


def get_zero_trust_device_managed_networks(account_id: Optional[builtins.str] = None,
                                           network_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustDeviceManagedNetworksResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_device_managed_networks = cloudflare.get_zero_trust_device_managed_networks(account_id="699d98642c564d2e855e9661899b7252",
        network_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str network_id: API UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['networkId'] = network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustDeviceManagedNetworks:getZeroTrustDeviceManagedNetworks', __args__, opts=opts, typ=GetZeroTrustDeviceManagedNetworksResult).value

    return AwaitableGetZeroTrustDeviceManagedNetworksResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        config=pulumi.get(__ret__, 'config'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        type=pulumi.get(__ret__, 'type'))
def get_zero_trust_device_managed_networks_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  network_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustDeviceManagedNetworksResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_device_managed_networks = cloudflare.get_zero_trust_device_managed_networks(account_id="699d98642c564d2e855e9661899b7252",
        network_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str network_id: API UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['networkId'] = network_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustDeviceManagedNetworks:getZeroTrustDeviceManagedNetworks', __args__, opts=opts, typ=GetZeroTrustDeviceManagedNetworksResult)
    return __ret__.apply(lambda __response__: GetZeroTrustDeviceManagedNetworksResult(
        account_id=pulumi.get(__response__, 'account_id'),
        config=pulumi.get(__response__, 'config'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        type=pulumi.get(__response__, 'type')))
