# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustDevicePostureRuleResult',
    'AwaitableGetZeroTrustDevicePostureRuleResult',
    'get_zero_trust_device_posture_rule',
    'get_zero_trust_device_posture_rule_output',
]

@pulumi.output_type
class GetZeroTrustDevicePostureRuleResult:
    """
    A collection of values returned by getZeroTrustDevicePostureRule.
    """
    def __init__(__self__, account_id=None, description=None, expiration=None, id=None, input=None, matches=None, name=None, rule_id=None, schedule=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if input and not isinstance(input, dict):
            raise TypeError("Expected argument 'input' to be a dict")
        pulumi.set(__self__, "input", input)
        if matches and not isinstance(matches, list):
            raise TypeError("Expected argument 'matches' to be a list")
        pulumi.set(__self__, "matches", matches)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if schedule and not isinstance(schedule, str):
            raise TypeError("Expected argument 'schedule' to be a str")
        pulumi.set(__self__, "schedule", schedule)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the device posture rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expiration(self) -> builtins.str:
        """
        Sets the expiration time for a posture check result. If empty, the result remains valid until it is overwritten by new data from the WARP client.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        API UUID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def input(self) -> 'outputs.GetZeroTrustDevicePostureRuleInputResult':
        """
        The value to be checked against.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetZeroTrustDevicePostureRuleMatchResult']:
        """
        The conditions that the client must match to run the rule.
        """
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the device posture rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[builtins.str]:
        """
        API UUID.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def schedule(self) -> builtins.str:
        """
        Polling frequency for the WARP client posture check. Default: `5m` (poll every five minutes). Minimum: `1m`.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of device posture rule.
        Available values: "file", "application", "tanium", "gateway", "warp", "disk*encryption", "serial*number", "sentinelone", "carbonblack", "firewall", "os*version", "domain*joined", "client*certificate", "client*certificate*v2", "unique*client*id", "kolide", "tanium*s2s", "crowdstrike*s2s", "intune", "workspace*one", "sentinelone*s2s", "custom*s2s".
        """
        return pulumi.get(self, "type")


class AwaitableGetZeroTrustDevicePostureRuleResult(GetZeroTrustDevicePostureRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustDevicePostureRuleResult(
            account_id=self.account_id,
            description=self.description,
            expiration=self.expiration,
            id=self.id,
            input=self.input,
            matches=self.matches,
            name=self.name,
            rule_id=self.rule_id,
            schedule=self.schedule,
            type=self.type)


def get_zero_trust_device_posture_rule(account_id: Optional[builtins.str] = None,
                                       rule_id: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustDevicePostureRuleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_device_posture_rule = cloudflare.get_zero_trust_device_posture_rule(account_id="699d98642c564d2e855e9661899b7252",
        rule_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str rule_id: API UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['ruleId'] = rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustDevicePostureRule:getZeroTrustDevicePostureRule', __args__, opts=opts, typ=GetZeroTrustDevicePostureRuleResult).value

    return AwaitableGetZeroTrustDevicePostureRuleResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        description=pulumi.get(__ret__, 'description'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        input=pulumi.get(__ret__, 'input'),
        matches=pulumi.get(__ret__, 'matches'),
        name=pulumi.get(__ret__, 'name'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        schedule=pulumi.get(__ret__, 'schedule'),
        type=pulumi.get(__ret__, 'type'))
def get_zero_trust_device_posture_rule_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                              rule_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustDevicePostureRuleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_device_posture_rule = cloudflare.get_zero_trust_device_posture_rule(account_id="699d98642c564d2e855e9661899b7252",
        rule_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str rule_id: API UUID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['ruleId'] = rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustDevicePostureRule:getZeroTrustDevicePostureRule', __args__, opts=opts, typ=GetZeroTrustDevicePostureRuleResult)
    return __ret__.apply(lambda __response__: GetZeroTrustDevicePostureRuleResult(
        account_id=pulumi.get(__response__, 'account_id'),
        description=pulumi.get(__response__, 'description'),
        expiration=pulumi.get(__response__, 'expiration'),
        id=pulumi.get(__response__, 'id'),
        input=pulumi.get(__response__, 'input'),
        matches=pulumi.get(__response__, 'matches'),
        name=pulumi.get(__response__, 'name'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        schedule=pulumi.get(__response__, 'schedule'),
        type=pulumi.get(__response__, 'type')))
