# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustDexTestResult',
    'AwaitableGetZeroTrustDexTestResult',
    'get_zero_trust_dex_test',
    'get_zero_trust_dex_test_output',
]

@pulumi.output_type
class GetZeroTrustDexTestResult:
    """
    A collection of values returned by getZeroTrustDexTest.
    """
    def __init__(__self__, account_id=None, data=None, description=None, dex_test_id=None, enabled=None, id=None, interval=None, name=None, target_policies=None, targeted=None, test_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dex_test_id and not isinstance(dex_test_id, str):
            raise TypeError("Expected argument 'dex_test_id' to be a str")
        pulumi.set(__self__, "dex_test_id", dex_test_id)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interval and not isinstance(interval, str):
            raise TypeError("Expected argument 'interval' to be a str")
        pulumi.set(__self__, "interval", interval)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if target_policies and not isinstance(target_policies, list):
            raise TypeError("Expected argument 'target_policies' to be a list")
        pulumi.set(__self__, "target_policies", target_policies)
        if targeted and not isinstance(targeted, bool):
            raise TypeError("Expected argument 'targeted' to be a bool")
        pulumi.set(__self__, "targeted", targeted)
        if test_id and not isinstance(test_id, str):
            raise TypeError("Expected argument 'test_id' to be a str")
        pulumi.set(__self__, "test_id", test_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def data(self) -> 'outputs.GetZeroTrustDexTestDataResult':
        """
        The configuration object which contains the details for the WARP client to conduct the test.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Additional details about the test.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dexTestId")
    def dex_test_id(self) -> Optional[builtins.str]:
        """
        The unique identifier for the test.
        """
        return pulumi.get(self, "dex_test_id")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Determines whether or not the test is active.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier for the test.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> builtins.str:
        """
        How often the test will run.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the DEX test. Must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetPolicies")
    def target_policies(self) -> Sequence['outputs.GetZeroTrustDexTestTargetPolicyResult']:
        """
        DEX rules targeted by this test
        """
        return pulumi.get(self, "target_policies")

    @property
    @pulumi.getter
    def targeted(self) -> builtins.bool:
        return pulumi.get(self, "targeted")

    @property
    @pulumi.getter(name="testId")
    def test_id(self) -> builtins.str:
        """
        The unique identifier for the test.
        """
        return pulumi.get(self, "test_id")


class AwaitableGetZeroTrustDexTestResult(GetZeroTrustDexTestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustDexTestResult(
            account_id=self.account_id,
            data=self.data,
            description=self.description,
            dex_test_id=self.dex_test_id,
            enabled=self.enabled,
            id=self.id,
            interval=self.interval,
            name=self.name,
            target_policies=self.target_policies,
            targeted=self.targeted,
            test_id=self.test_id)


def get_zero_trust_dex_test(account_id: Optional[builtins.str] = None,
                            dex_test_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustDexTestResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_dex_test = cloudflare.get_zero_trust_dex_test(account_id="01a7362d577a6c3019a474fd6f485823",
        dex_test_id="372e67954025e0ba6aaa6d586b9e0b59")
    ```


    :param builtins.str dex_test_id: The unique identifier for the test.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['dexTestId'] = dex_test_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustDexTest:getZeroTrustDexTest', __args__, opts=opts, typ=GetZeroTrustDexTestResult).value

    return AwaitableGetZeroTrustDexTestResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        data=pulumi.get(__ret__, 'data'),
        description=pulumi.get(__ret__, 'description'),
        dex_test_id=pulumi.get(__ret__, 'dex_test_id'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        interval=pulumi.get(__ret__, 'interval'),
        name=pulumi.get(__ret__, 'name'),
        target_policies=pulumi.get(__ret__, 'target_policies'),
        targeted=pulumi.get(__ret__, 'targeted'),
        test_id=pulumi.get(__ret__, 'test_id'))
def get_zero_trust_dex_test_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                   dex_test_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustDexTestResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_dex_test = cloudflare.get_zero_trust_dex_test(account_id="01a7362d577a6c3019a474fd6f485823",
        dex_test_id="372e67954025e0ba6aaa6d586b9e0b59")
    ```


    :param builtins.str dex_test_id: The unique identifier for the test.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['dexTestId'] = dex_test_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustDexTest:getZeroTrustDexTest', __args__, opts=opts, typ=GetZeroTrustDexTestResult)
    return __ret__.apply(lambda __response__: GetZeroTrustDexTestResult(
        account_id=pulumi.get(__response__, 'account_id'),
        data=pulumi.get(__response__, 'data'),
        description=pulumi.get(__response__, 'description'),
        dex_test_id=pulumi.get(__response__, 'dex_test_id'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        interval=pulumi.get(__response__, 'interval'),
        name=pulumi.get(__response__, 'name'),
        target_policies=pulumi.get(__response__, 'target_policies'),
        targeted=pulumi.get(__response__, 'targeted'),
        test_id=pulumi.get(__response__, 'test_id')))
