# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustRiskScoringIntegrationResult',
    'AwaitableGetZeroTrustRiskScoringIntegrationResult',
    'get_zero_trust_risk_scoring_integration',
    'get_zero_trust_risk_scoring_integration_output',
]

@pulumi.output_type
class GetZeroTrustRiskScoringIntegrationResult:
    """
    A collection of values returned by getZeroTrustRiskScoringIntegration.
    """
    def __init__(__self__, account_id=None, account_tag=None, active=None, created_at=None, id=None, integration_id=None, integration_type=None, reference_id=None, tenant_url=None, well_known_url=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if account_tag and not isinstance(account_tag, str):
            raise TypeError("Expected argument 'account_tag' to be a str")
        pulumi.set(__self__, "account_tag", account_tag)
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integration_id and not isinstance(integration_id, str):
            raise TypeError("Expected argument 'integration_id' to be a str")
        pulumi.set(__self__, "integration_id", integration_id)
        if integration_type and not isinstance(integration_type, str):
            raise TypeError("Expected argument 'integration_type' to be a str")
        pulumi.set(__self__, "integration_type", integration_type)
        if reference_id and not isinstance(reference_id, str):
            raise TypeError("Expected argument 'reference_id' to be a str")
        pulumi.set(__self__, "reference_id", reference_id)
        if tenant_url and not isinstance(tenant_url, str):
            raise TypeError("Expected argument 'tenant_url' to be a str")
        pulumi.set(__self__, "tenant_url", tenant_url)
        if well_known_url and not isinstance(well_known_url, str):
            raise TypeError("Expected argument 'well_known_url' to be a str")
        pulumi.set(__self__, "well_known_url", well_known_url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountTag")
    def account_tag(self) -> builtins.str:
        """
        The Cloudflare account tag.
        """
        return pulumi.get(self, "account_tag")

    @property
    @pulumi.getter
    def active(self) -> builtins.bool:
        """
        Whether this integration is enabled and should export changes in risk score.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        When the integration was created in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> builtins.str:
        """
        Available values: "Okta".
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> builtins.str:
        """
        A reference ID defined by the client.
        Should be set to the Access-Okta IDP integration ID.
        Useful when the risk-score integration needs to be associated with a secondary asset and recalled using that ID.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="tenantUrl")
    def tenant_url(self) -> builtins.str:
        """
        The base URL for the tenant. E.g. "https://tenant.okta.com".
        """
        return pulumi.get(self, "tenant_url")

    @property
    @pulumi.getter(name="wellKnownUrl")
    def well_known_url(self) -> builtins.str:
        """
        The URL for the Shared Signals Framework configuration, e.g. "/.well-known/sse-configuration/{integration*uuid}/". https://openid.net/specs/openid-sse-framework-1*0.html#rfc.section.6.2.1.
        """
        return pulumi.get(self, "well_known_url")


class AwaitableGetZeroTrustRiskScoringIntegrationResult(GetZeroTrustRiskScoringIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustRiskScoringIntegrationResult(
            account_id=self.account_id,
            account_tag=self.account_tag,
            active=self.active,
            created_at=self.created_at,
            id=self.id,
            integration_id=self.integration_id,
            integration_type=self.integration_type,
            reference_id=self.reference_id,
            tenant_url=self.tenant_url,
            well_known_url=self.well_known_url)


def get_zero_trust_risk_scoring_integration(account_id: Optional[builtins.str] = None,
                                            integration_id: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustRiskScoringIntegrationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_risk_scoring_integration = cloudflare.get_zero_trust_risk_scoring_integration(account_id="account_id",
        integration_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['integrationId'] = integration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustRiskScoringIntegration:getZeroTrustRiskScoringIntegration', __args__, opts=opts, typ=GetZeroTrustRiskScoringIntegrationResult).value

    return AwaitableGetZeroTrustRiskScoringIntegrationResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        account_tag=pulumi.get(__ret__, 'account_tag'),
        active=pulumi.get(__ret__, 'active'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        integration_id=pulumi.get(__ret__, 'integration_id'),
        integration_type=pulumi.get(__ret__, 'integration_type'),
        reference_id=pulumi.get(__ret__, 'reference_id'),
        tenant_url=pulumi.get(__ret__, 'tenant_url'),
        well_known_url=pulumi.get(__ret__, 'well_known_url'))
def get_zero_trust_risk_scoring_integration_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   integration_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustRiskScoringIntegrationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_risk_scoring_integration = cloudflare.get_zero_trust_risk_scoring_integration(account_id="account_id",
        integration_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
    ```
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['integrationId'] = integration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustRiskScoringIntegration:getZeroTrustRiskScoringIntegration', __args__, opts=opts, typ=GetZeroTrustRiskScoringIntegrationResult)
    return __ret__.apply(lambda __response__: GetZeroTrustRiskScoringIntegrationResult(
        account_id=pulumi.get(__response__, 'account_id'),
        account_tag=pulumi.get(__response__, 'account_tag'),
        active=pulumi.get(__response__, 'active'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        integration_id=pulumi.get(__response__, 'integration_id'),
        integration_type=pulumi.get(__response__, 'integration_type'),
        reference_id=pulumi.get(__response__, 'reference_id'),
        tenant_url=pulumi.get(__response__, 'tenant_url'),
        well_known_url=pulumi.get(__response__, 'well_known_url')))
